% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{CalibrateEffectiveLabelingTimeMatchHalflives}
\alias{CalibrateEffectiveLabelingTimeMatchHalflives}
\title{Calibrate the effective labeling time by matching half-lives to a .reference}
\usage{
CalibrateEffectiveLabelingTimeMatchHalflives(
  data,
  reference.halflives = NULL,
  reference.columns = NULL,
  slot = DefaultSlot(data),
  time.labeling = Design$dur.4sU,
  time.experiment = NULL,
  time.name = "calibrated_time",
  n.estimate = 1000,
  verbose = FALSE
)
}
\arguments{
\item{data}{A grandR object}

\item{reference.halflives}{a vector of reference Half-lives named by genes}

\item{reference.columns}{the reference column description}

\item{slot}{The data slot to take expression values from}

\item{time.labeling}{the column in the column annotation table denoting the labeling duration or the labeling duration itself}

\item{time.experiment}{the column in the column annotation table denoting the experimental time point (can be NULL, see details)}

\item{time.name}{The name in the column annotation table to put the calibrated labeling durations}

\item{n.estimate}{the times are calibrated with the top n expressed genes}

\item{verbose}{verbose output}
}
\value{
A new grandR object containing the calibrated durations in the column data annotation
}
\description{
The NTRs of each sample might be systematically too small (or large). This function identifies such systematic
deviations and computes labeling durations without systematic deviations.
}
\seealso{
\link{FitKineticsGeneSnapshot}
}
\concept{recalibration}
