% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{NormalizeBaseline}
\alias{NormalizeBaseline}
\title{Normalization to a baseline}
\usage{
NormalizeBaseline(
  data,
  baseline = FindReferences(data, reference = Condition == levels(Condition)[1]),
  name = "baseline",
  slot = DefaultSlot(data),
  set.to.default = FALSE,
  LFC.fun = lfc::PsiLFC,
  ...
)
}
\arguments{
\item{data}{the grandR object}

\item{baseline}{matrix defining the corresponding baseline (row) for each column (sample or cell; see details)}

\item{name}{the name of the new slot for the normalized data}

\item{slot}{the name of the slot for the data to normalize}

\item{set.to.default}{set the new slot as the default slot}

\item{LFC.fun}{either \link[lfc]{NormLFC} or \link[lfc]{PsiLFC} from the lfc package}

\item{...}{forwarded to LFC.fun}
}
\value{
a new grandR object with an additional slot
}
\description{
Normalizes data in a grandR object to a baseline and puts the normalized data into a new slot
}
\details{
Baseline normalization computes the log2 fold change for a column (i.e. sample or cell) to a baseline columns (or several baseline columns). This is by default done using the
\code{\link[lfc]{PsiLFC}} function from the lfc package, which, by default, also normalizes log2 fold changes by adding a constant
such that the median is zero.

Baselines are defined by a square logical matrix, defining for each sample or cell of the grandR object, represented by the column of the matrix,
which samples or cells are indeed the baseline (represented by the rows). Such matrices can conveniently be obtained by \code{\link{FindReferences}}.
}
\examples{
sars <- ReadGRAND(system.file("extdata", "sars.tsv.gz", package = "grandR"),
                  design=c("Cell",Design$dur.4sU,Design$Replicate))
blmat <- FindReferences(sars,reference = duration.4sU==0, group = "Cell")
# the Mock.no4sU or SARS.no4sU sample are the baselines for each sample
sars <- NormalizeBaseline(sars,baseline=blmat)
head(GetTable(sars,type="baseline"))
}
\seealso{
\code{\link{Normalize}},\code{\link{FindReferences}}
}
\concept{preprocess}
