% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grangersearch.R
\name{plot.granger_lag_select}
\alias{plot.granger_lag_select}
\title{Plot Lag Selection Results}
\usage{
\method{plot}{granger_lag_select}(x, ...)
}
\arguments{
\item{x}{A \code{granger_lag_select} object from \code{\link[=granger_lag_select]{granger_lag_select()}}.}

\item{...}{Additional arguments (ignored).}
}
\value{
A base R plot (invisibly returns the input).
}
\description{
Creates a visualization of p-values across different lag orders for
Granger causality tests.
}
\details{
This function creates a line plot showing how p-values change across
different lag orders for each directed pair. A horizontal dashed line
indicates the significance threshold (alpha).

For more customized plots, use the data directly with ggplot2.
}
\examples{
set.seed(123)
df <- data.frame(A = cumsum(rnorm(100)), B = cumsum(rnorm(100)))
df$B <- c(0, 0.7 * df$A[1:99]) + rnorm(100, sd = 0.5)

lag_results <- granger_lag_select(df, lag = 1:5)
plot(lag_results)

}
