% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters.R
\name{getter}
\alias{getter}
\alias{getNumberOfNodes}
\alias{getNumberOfEdges}
\alias{getNumberOfClusters}
\alias{getNumberOfWeights}
\alias{getNodeCoordinates}
\alias{getWeightMatrix}
\alias{getAdjacencyMatrix}
\alias{getNodeDegrees}
\title{Getter functions.}
\usage{
getNumberOfNodes(graph)

getNumberOfEdges(graph)

getNumberOfClusters(graph)

getNumberOfWeights(graph)

getNodeCoordinates(graph, cluster.centers = FALSE)

getWeightMatrix(graph, objective)

getAdjacencyMatrix(graph)

getNodeDegrees(graph)
}
\arguments{
\item{graph}{[\code{\link{grapherator}}]\cr
Graph.}

\item{cluster.centers}{[\code{logical(1)}]\cr
Return coordinates of cluster centers only?
Default is \code{FALSE}.}

\item{objective}{[\code{integer(1)}]\cr
Number of weight matrix to return.}
}
\description{
Functions to extract meta information of \code{grapherator} object.
}
\examples{
g = graph(0, 100)
g = addNodes(g, n = 25, generator = addNodesGrid)
g = addEdges(g, generator = addEdgesGrid)
g = addWeights(g, generator = addWeightsRandom, method = runif, min = 5, max = 100, to.int = TRUE)
g = addWeights(g, generator = addWeightsDistance, method = "euclidean")

getNumberOfNodes(g)
getNumberOfEdges(g)
getNumberOfClusters(g)
getNumberOfWeights(g)
getNodeCoordinates(g)
getWeightMatrix(g, 2)
getAdjacencyMatrix(g)
getNodeDegrees(g)
}
