% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_sparse.R
\name{extract_sparse}
\alias{extract_sparse}
\title{Extracts the sparse part from a (U,W) graphon mixture}
\usage{
extract_sparse(gr)
}
\arguments{
\item{gr}{The input graph}
}
\value{
a list with the following components:
\item{\code{num_hubs}}{The number of hubs in the sparse component.}
\item{\code{phat}}{The probability vector of the sparse component. This is also known as the mass partition.}
\item{\code{segment_sizes}}{The sizes of the two line segments.}
\item{\code{line_equations}}{The two equations of the lines.}
\item{\code{cutoff}}{The best cut off for the two lines.}
\item{\code{models}}{The models of the fitted lines. }
\item{\code{mse}}{The mean squared error}
\item{\code{data}}{The degree data.}
}
\description{
This function extracts the sparse component from a (U,W) mixture graph by
fitting two lines to the unique sorted log degree values. The first line gives
the number of hubs in the sparse part and the remaining line fits the degrees
of the dense part.
}
\examples{
library(igraph)
gr <- sample_pa(10000, power = 1.2, directed = FALSE)
sparse <- extract_sparse(gr)
sparse$phat

}
