% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphon_generation.R
\name{graph_join}
\alias{graph_join}
\title{Joins two graphs}
\usage{
graph_join(gr1, gr2, p = 0.5, option = 2)
}
\arguments{
\item{gr1}{The first graph to join}

\item{gr2}{The second graph to join}

\item{p}{The proportion of edges in \code{gr1} to be added as part of the joining}

\item{option}{Two options. 1 does the disjoint union, 2 does the random edges union.}
}
\value{
The joined graph
}
\description{
Joins two graphs randomly connecting vertices
}
\examples{
W <- create_exp_matrix(100, 100)
# create the sparse part - a disjoint set of stars
wts <- c(0.5, 0.3, 0.2)
grdense <- sample_graphon(W, 100)
grsparse <- generate_star_union(wts, 200)
gr <- graph_join(grdense, grsparse, opt = 2)

}
