% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pharma_layout.R
\name{pharma_layout_base}
\alias{pharma_layout_base}
\title{Base Function for Pharma Layouts}
\usage{
pharma_layout_base(
  margin = grid::unit(c(t = 1, r = 1, b = 1, l = 1), units = "inches"),
  global_gpar = NULL,
  background = grid::get.gpar()$fill,
  adjust_height = TRUE
)
}
\arguments{
\item{margin}{A \code{grid::unit} object defining the margins of the layout (top, right, bottom, left) in inches.
Default is \code{grid::unit(c(1, 1, 1, 1), "inches")}.}

\item{global_gpar}{A list specifying global graphical parameters to change in the layout.
Default is NULL,
however the defaults in the layout are: \verb{fontfamily = "Serif", fontsize = 9 and lineheight = 0.95},
which can be overwritten alongside other graphical parameters found by \code{grid::get.gpar()}.}

\item{background}{A string specifying the background fill colour.
Default \code{grid::get.gpar()$fill} for a white background.}

\item{adjust_height}{A logical value indicating whether to adjust the height of the layout. Default is \code{TRUE}.}
}
\value{
A \code{gridifyLayout} object that defines the general structure and parameters for a pharma layout.
}
\description{
This function sets up the general structure for positioning text
elements for pharma layouts.
It defines the layout with specified margins, global graphical parameters, and height adjustment.
The layout includes cells for headers, titles, footers, and optional elements like watermarks.
}
\details{
This function is primarily used internally by other layout functions such as \code{pharma_layout_A4()} and
\code{pharma_layout_letter()} to create specific layouts.
}
\note{
\strong{The Font Issue Information:}

Changes to the fontfamily may be ignored by some devices, but is supported by
PostScript, PDF, X11, Windows, and Quartz. The fontfamily may be used to specify
one of the Hershey Font families (e.g., HersheySerif, serif), and this specification will be
honoured on all devices.

If you encounter this warning, you can register the fonts using the \code{extrafont} package:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(extrafont)
font_import()
loadfonts(device = 'all')
}\if{html}{\out{</div>}}

If you still see the warning while using RStudio, try changing the graphics backend.

\strong{Negative Dimensions Issues:}

grobs from the grid package and ggplot2 objects (when converted to grobs by gridify)
may appear distorted in the output
if there is insufficient space in the window, caused by negative dimensions.
This should be resolved. However, if this is affecting your layout, please increase your window size or
only use static heights/widths for custom layouts.

The negative dimensions are caused by the way grid handles \code{null} and \code{npc} heights/widths so if some dimensions are
static, then the \code{npc} or \code{null} values may cause unexpected behaviour when the window size is too small.
It was resolved by setting a minimum size of the object in the gridify object to 1 inch for each dimension.

The following example demonstrates this behaviour
Try resizing your window:

\preformatted{
library(grid)
library(ggplot2)
grid.newpage()
object <- ggplot2::ggplotGrob(ggplot(mtcars, aes(mpg, wt)) + geom_line())
grid::grid.draw(
  grid::grobTree(
    grid::grobTree(
      grid::editGrob(
        object,
        vp = grid::viewport(
          # height = grid::unit.pmax(grid::unit(1, "npc"), grid::unit(1, "inch")),
          # width = grid::unit.pmax(grid::unit(1, "npc"), grid::unit(1, "inch"))
        )
      ),
      vp = grid::viewport(
        layout.pos.row = 2,
        layout.pos.col = 1:3
      )
    ),
    vp = grid::viewport(
      layout = grid::grid.layout(
        nrow = 3,
        ncol = 3,
        heights = grid::unit(c(9, 1, 9), c("cm", "null", "cm"))
      )
    )
  )
)
}

\strong{gt Font Size Issue:}

When specifying font sizes, the \code{gt} package interprets values as having the
unit pixels (\code{px}), whilst the \code{grid} package, on which \code{gridify} is built,
assumes points (\code{pt}). As a result, even if you set the font sizes in both
\code{gt} and \code{gridify} (using \code{grid::gpar()}) to the same number, they may
still appear different. To convert point size to pixel size, multiply the point size by \code{96 / 72}.
}
\examples{
# Create a general pharma layout with default settings
pharma_layout_base()

library(magrittr)
# Customize margins and global graphical parameters and fill all cells
gridify(
  object = ggplot2::ggplot(data = mtcars, ggplot2::aes(x = mpg, y = wt)) +
    ggplot2::geom_line(),
  layout = pharma_layout_base(
    margin = grid::unit(c(0.5, 0.5, 0.5, 0.5), "inches"),
    global_gpar = list(col = "blue", fontsize = 10)
  )
) \%>\%
  set_cell("header_left_1", "My Company") \%>\%
  set_cell("header_left_2", "<PROJECT> / <INDICATION>") \%>\%
  set_cell("header_left_3", "<STUDY>") \%>\%
  set_cell("header_right_1", "CONFIDENTIAL") \%>\%
  set_cell("header_right_2", "<Draft or Final>") \%>\%
  set_cell("header_right_3", "Data Cut-off: YYYY-MM-DD") \%>\%
  set_cell("output_num", "<Output> xx.xx.xx") \%>\%
  set_cell("title_1", "<Title 1>") \%>\%
  set_cell("title_2", "<Title 2>") \%>\%
  set_cell("title_3", "<Optional Title 3>") \%>\%
  set_cell("by_line", "By: <GROUP>, <optionally: Demographic parameters>") \%>\%
  set_cell("note", "<Note or Footnotes>") \%>\%
  set_cell("references", "<References:>") \%>\%
  set_cell("footer_left", "Program: <PROGRAM NAME>, YYYY-MM-DD at HH:MM") \%>\%
  set_cell("footer_right", "Page xx of nn") \%>\%
  set_cell("watermark", "DRAFT")

}
\seealso{
\link{pharma_layout}, \code{\link[=pharma_layout_A4]{pharma_layout_A4()}}, \code{\link[=pharma_layout_letter]{pharma_layout_letter()}}
}
