test_that("Snapshot test for fixed_design_ahr summary as_rtf", {
  skip_on_cran()

  path <- tempfile(fileext = ".rtf")
  fixed_design_ahr_example() |>
    summary() |>
    as_rtf(file = path)

  local_edition(3)
  expect_snapshot_file(path, "fixed_design_ahr.rtf")
})

test_that("Snapshot test for fixed_design_ahr summary as_rtf with custom title", {
  skip_on_cran()

  path <- tempfile(fileext = ".rtf")
  fixed_design_ahr_example() |>
    summary() |>
    as_rtf(
      title = "Fixed design under non-proportional hazards",
      file = path
    )

  local_edition(3)
  expect_snapshot_file(path, "fixed_design_ahr_title.rtf")
})

test_that("Snapshot test for fixed_design_ahr summary as_rtf with custom footnote", {
  skip_on_cran()

  path <- tempfile(fileext = ".rtf")
  fixed_design_ahr_example() |>
    summary() |>
    as_rtf(
      footnote = "Power computed with average hazard ratio method given the sample size",
      file = path
    )

  local_edition(3)
  expect_snapshot_file(path, "fixed_design_ahr_footnote.rtf")
})

test_that("Snapshot test for gs_design_ahr summary as_rtf", {
  skip_on_cran()

  path <- tempfile(fileext = ".rtf")
  gs_design_ahr() |>
    summary() |>
    as_rtf(file = path)

  local_edition(3)
  expect_snapshot_file(path, "gs_design_ahr.rtf")
})

test_that("Snapshot test for gs_design_wlr summary as_rtf", {
  skip_on_cran()

  path <- tempfile(fileext = ".rtf")
  gs_design_wlr() |>
    summary() |>
    as_rtf(file = path)

  local_edition(3)
  expect_snapshot_file(path, "gs_design_wlr.rtf")
})

test_that("Snapshot test for gs_power_wlr summary as_rtf", {
  skip_on_cran()

  path <- tempfile(fileext = ".rtf")
  gs_power_wlr_example() |>
    summary() |>
    as_rtf(file = path)

  local_edition(3)
  expect_snapshot_file(path, "gs_power_wlr.rtf")
})

test_that("Snapshot test for gs_design_rd summary as_rtf", {
  skip_on_cran()

  path <- tempfile(fileext = ".rtf")
  gs_design_rd() |>
    summary() |>
    as_rtf(file = path)

  local_edition(3)
  expect_snapshot_file(path, "gs_design_rd.rtf")
})

test_that("Snapshot test for gs_power_wlr summary as_rtf with custom title and subtitle", {
  skip_on_cran()

  path <- tempfile(fileext = ".rtf")
  gs_power_wlr_example() |>
    summary() |>
    as_rtf(
      title = "Bound Summary",
      subtitle = "from gs_power_wlr",
      file = path
    )

  local_edition(3)
  expect_snapshot_file(path, "gs_power_wlr_title.rtf")
})

test_that("Snapshot test for gs_power_wlr summary as_rtf with custom spanner and sub-spanner", {
  skip_on_cran()

  path <- tempfile(fileext = ".rtf")
  gs_power_wlr_example() |>
    summary() |>
    as_rtf(
      colname_spanner = "Cumulative probability to cross boundaries",
      colname_spannersub = c("under H1", "under H0"),
      file = path
    )

  local_edition(3)
  expect_snapshot_file(path, "gs_power_wlr_spanner.rtf")
})

test_that("Snapshot test for gs_power_wlr summary as_rtf with custom footnote", {
  skip_on_cran()

  path <- tempfile(fileext = ".rtf")
  gs_power_wlr_example() |>
    summary() |>
    as_rtf(
      footnote = list(
        content = c(
          "approximate weighted hazard ratio to cross bound.",
          "wAHR is the weighted AHR.",
          "the crossing probability.",
          "this table is generated by gs_power_wlr."
        ),
        location = c("~wHR at bound", NA, NA, NA),
        attr = c("colname", "analysis", "spanner", "title")
      ),
      file = path
    )

  local_edition(3)
  expect_snapshot_file(path, "gs_power_wlr_footnote.rtf")
})

test_that("Snapshot test for gs_power_wlr summary as_rtf with custom columns to display", {
  skip_on_cran()

  path <- tempfile(fileext = ".rtf")
  gs_power_wlr_example() |>
    summary() |>
    as_rtf(
      display_columns = c("Analysis", "Bound", "Nominal p", "Z", "Probability"),
      file = path
    )

  local_edition(3)
  expect_snapshot_file(path, "gs_power_wlr_cols_display.rtf")
})

test_that("Snapshot test for gs_power_wlr summary as_rtf with efficacy bounds displayed", {
  skip_on_cran()

  path <- tempfile(fileext = ".rtf")
  gs_power_wlr_example() |>
    summary() |>
    as_rtf(display_bound = "Efficacy", file = path)

  local_edition(3)
  expect_snapshot_file(path, "gs_power_wlr_efficacy_bound.rtf")
})

test_that("Snapshot test for gs_power_wlr summary as_rtf with futility bounds displayed", {
  skip_on_cran()

  path <- tempfile(fileext = ".rtf")
  gs_power_wlr_example(binding = TRUE) |>
    summary() |>
    as_rtf(display_bound = "Futility", file = path)

  local_edition(3)
  expect_snapshot_file(path, "gs_power_wlr_futility_bound.rtf")
})
