% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_surv.R
\name{design_surv}
\alias{design_surv}
\title{Design the clinical trial for survival outcome}
\usage{
design_surv(m0, alpha, beta, k, hr0, hr1, ta, tf, kappa, eta, frac)
}
\arguments{
\item{m0}{numeric Median survival time of control group.}

\item{alpha}{numeric Type I error.}

\item{beta}{numeric Type II error.}

\item{k}{numeric Number of treatment arms.}

\item{hr0}{numeric Hazard ratio of ineffective treatment group vs control.}

\item{hr1}{numeric Hazard ratio of effective treatment group vs control.}

\item{ta}{numeric Accrual time.}

\item{tf}{numeric Follow-up time.}

\item{kappa}{numeric Shape parameter (kappa=1 for exponential distribution).}

\item{eta}{numeric Rate of loss to follow-up.}

\item{frac}{numeric Vector of fractions for information time at each look.}
}
\value{
List of cumulative number of events for each stage of combined treatment and control groups along with total number of subjects and maximum total number of events for the trial. It also provides efficacy and futility boundaries of the trial.
}
\description{
This function generates the design parameters of a clinical trial for survival outcome.
}
\examples{
design_surv(m0 = 20,
            hr0 = 1,
            hr1 = 0.65,
            ta = 20,
            tf = 40,
            alpha = 0.05,
            beta = 0.1,
            k = 3,
            kappa = 1,
            eta = 0,
            frac = c(1 / 2, 1))
}
