\name{tfuStandard}
\alias{tfuStandard}
\title{Standardize follow-up times}
\usage{tfuStandard(tfu, tref=c(1,2))}
\description{Standardize the follow-up (early) time-points.}
\arguments{
 \item{tfu}{A vector of length \code{s}, of follow-up time points, in the same
   units as the recruitment time (\code{trecruit}) from from function
   \code{\link{gsearlyModel}} or \code{\link{gsearlyUser}}.}
 \item{tref}{A vector of integers of length 2 that defines the correlation
   parameter \code{rho} for the exponential model \code{\link{corrExp}}; the
   parameter \code{rho} is the correlation between data at times
   \code{tfu[tref[1]]} and \code{tfu[tref[2]]}, with default \code{c(1,2)}.}
}
\value{
 A list  containing the following components.
 \item{tfu}{Follow-up time points.}
 \item{stfu}{Standardized follow-up time-points, depending on the selected
   reference categories \code{tref}.}
}
\examples{

 # Early outcomes at 3, 6 and 12 months, and final at 24 months
 # Standardized to units of 3 months if tref is c(1,2)
 tfuStandard(c(3,6,12,24), tref=c(1,2))

 # Standardized to yearly units if tref is c(1,2)
 tfuStandard(c(3,6,12,24), tref=c(3,4))

}
