% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pei_tseng_notch.R
\name{pei_tseng_notch}
\alias{pei_tseng_notch}
\title{Pei-Tseng notch filter}
\usage{
pei_tseng_notch(w, bw)
}
\arguments{
\item{w}{vector of critical frequencies of the filter. Must be between 0
and 1 where 1 is the Nyquist frequency.}

\item{bw}{vector of bandwidths. Bw should be of the same length as \code{w}.}
}
\value{
List of class \code{\link{Arma}} with list elements:
\describe{
  \item{b}{moving average (MA) polynomial coefficients}
  \item{a}{autoregressive (AR) polynomial coefficients}
}
}
\description{
Compute the transfer function coefficients of an IIR narrow-band notch
filter.
}
\details{
The filter construction is based on an all-pass which performs a reversal of
phase at the filter frequencies. Thus, the mean of the phase-distorted and
the original signal has the respective frequencies removed.
}
\examples{
## 50 Hz notch filter
fs <- 256
nyq <- fs / 2
notch <- pei_tseng_notch(50 / nyq, 2 / nyq)
freqz(notch, fs = fs)

}
\references{
Pei, Soo-Chang, and Tseng, Chien-Cheng "IIR Multiple Notch Filter
  Design Based on Allpass Filter"; 1996 IEEE Tencon, doi:
  \doi{10.1109/TENCON.1996.608814}
}
\seealso{
\code{\link{Arma}}, \code{\link{filter}}
}
\author{
Alexander Klein, \email{alexander.klein@math.uni-giessen.de}.\cr
 Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
