% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_check_linear.R
\name{.reg_check_linear}
\alias{.reg_check_linear}
\title{Linear Regression Diagnostic Checks (Internal)
similar to reg check in stata
Performs diagnostic tests for linear regression models:
- Breusch-Pagan test for heteroskedasticity
- Shapiro-Wilk test for normality of residuals
- RESET test for model specification
- Cook's Distance for influential points}
\usage{
.reg_check_linear(model, exposure)
}
\arguments{
\item{model}{A fitted linear model (`lm` object).}

\item{exposure}{Character string giving the name of the exposure variable (for labeling).}
}
\value{
A data frame with one row per diagnostic test, including:
\describe{
  \item{Exposure}{Name of the exposure variable.}
  \item{Test}{Diagnostic test name.}
  \item{Statistic}{Test statistic or summary (e.g., p-values).}
  \item{Interpretation}{Plain-language result interpretation.}
}
}
\description{
Linear Regression Diagnostic Checks (Internal)
similar to reg check in stata
Performs diagnostic tests for linear regression models:
- Breusch-Pagan test for heteroskedasticity
- Shapiro-Wilk test for normality of residuals
- RESET test for model specification
- Cook's Distance for influential points
}
\keyword{internal}
