% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_functions.R
\name{save_table}
\alias{save_table}
\title{Save a Single Regression Table}
\usage{
save_table(tbl, filename = "table", format = c("docx", "pdf", "html"))
}
\arguments{
\item{tbl}{A gtsummary object (e.g., tbl_regression(), tbl_summary()).}

\item{filename}{File name to save the output. Extension is optional.}

\item{format}{Output format. One of "docx", "pdf", or "html".}
}
\value{
Saves the file to a temporary directory (if no path is given). Does not return an object.
}
\description{
Saves a gtsummary table as a Word, PDF, or HTML file
}
\examples{
\donttest{
model <- glm(mpg ~ hp + wt, data = mtcars)
tbl <- gtsummary::tbl_regression(model)
save_table(tbl, filename = file.path(tempdir(), "regression_table"), format = "docx")
}
}
