% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratified_multi_reg.R
\name{stratified_multi_reg}
\alias{stratified_multi_reg}
\title{Stratified Multivariable Regression (Adjusted OR, RR, IRR, or Beta)}
\usage{
stratified_multi_reg(data, outcome, exposures, stratifier, approach = "logit")
}
\arguments{
\item{data}{A data frame containing the variables.}

\item{outcome}{name of the outcome variable.}

\item{exposures}{vector specifying the predictor (exposure) variables.}

\item{stratifier}{A character string specifying the stratifying variable.}

\item{approach}{Modeling approach to use. One of:
`"logit"` (Adjusted Odds Ratios), `"log-binomial"` (Adjusted Risk Ratios),
`"poisson"` (Adjusted IRRs), `"robpoisson"` (Adjusted RRs),
or `"linear"` (Beta coefficients), `"negbin"` (Adjusted IRRs).}
}
\value{
An object of class `stratified_multi_reg`, which includes:
- `table`: A `gtsummary::tbl_stack` object of regression tables by stratum,
- `models`: A named list of model objects for each stratum,
- `model_summaries`: A list of tidy model summaries,
- `reg_check`: Diagnostics results (if available for the model type).
}
\description{
Performs multivariable regression with multiple exposures on
a binary, count, or continuous outcome,
stratified by a specified variable.
NA values in the stratifier are excluded from analysis.
}
\section{Accessors}{

\describe{
  \item{\code{$table}}{Stacked table of stratified regression outputs.}
  \item{\code{$models}}{Named list of fitted models per stratum.}
  \item{\code{$model_summaries}}{Tidy summaries for each model.}
  \item{\code{$reg_check}}{Regression diagnostic checks (when applicable).}
}
}

\examples{
if (requireNamespace("mlbench", quietly = TRUE) &&
  requireNamespace("dplyr", quietly = TRUE)) {
  data(PimaIndiansDiabetes2, package = "mlbench")
  pima <- dplyr::mutate(
    PimaIndiansDiabetes2,
    diabetes = ifelse(diabetes == "pos", 1, 0),
    glucose_cat = dplyr::case_when(
      glucose < 140 ~ "Normal",
      glucose >= 140 ~ "High"
    )
  )
  stratified_multi <- stratified_multi_reg(
    data = pima,
    outcome = "diabetes",
    exposures = c("age", "mass"),
    stratifier = "glucose_cat",
    approach = "logit"
  )
  stratified_multi$table
}

}
\seealso{
[multi_reg()], [stratified_uni_reg()], [plot_reg()]
}
