% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_ard_strata.R
\name{tbl_ard_strata}
\alias{tbl_ard_strata}
\alias{tbl_ard_strata2}
\title{Stratified gtsummary tables from ARD}
\usage{
tbl_ard_strata(
  cards,
  strata,
  .tbl_fun,
  ...,
  .sep = ", ",
  .combine_with = c("tbl_merge", "tbl_stack"),
  .combine_args = NULL,
  .header = ifelse(.combine_with == "tbl_merge", "**{strata}**", "{strata}")
)

tbl_ard_strata2(
  cards,
  strata,
  .tbl_fun,
  ...,
  .sep = ", ",
  .combine_with = c("tbl_merge", "tbl_stack"),
  .combine_args = NULL,
  .header = ifelse(.combine_with == "tbl_merge", "**{strata}**", "{strata}")
)
}
\arguments{
\item{cards}{(\code{card})\cr
An ARD object of class \code{"card"} typically created with \verb{cards::ard_*()} functions.}

\item{strata}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
the grouping columns to stratify by.
Must select \code{'group#'} and \code{'group#_level'} pairs.
Importantly, the function expects the \code{'group#'} columns to be the same variable,
e.g. stratifying by a single variable.
The \code{'group#_level'} value is available to place in header (and more) via the \code{{strata}} element.}

\item{.tbl_fun}{(\code{function})
A function or formula. If a \emph{function}, it is used as is.
If a formula, e.g. \code{~ .x \%>\% tbl_summary() \%>\% add_p()}, it is converted to a function.
The stratified data frame is passed to this function.}

\item{...}{Additional arguments passed on to the \code{.tbl_fun} function.}

\item{.sep}{(\code{string})\cr
when more than one stratifying variable is passed, this string is
used to separate the levels in the spanning header. Default is \code{", "}}

\item{.combine_with}{(\code{string})\cr
One of \code{c("tbl_merge", "tbl_stack")}. Names the function
used to combine the stratified tables.}

\item{.combine_args}{(named \code{list})\cr
named list of arguments that are passed to function specified in \code{.combine_with}}

\item{.header}{(\code{string})\cr
String indicating the headers that will be placed.
Default is \code{"**{strata}**"} when \code{.combine_with = "tbl_merge"} and
\code{"{strata}"} when \code{.combine_with = "tbl_stack"}. Items placed in
curly brackets will be evaluated according to \code{glue::glue()} syntax.

\if{html}{\out{<div class="sourceCode">}}\preformatted{- `strata` stratum levels

- `n` N within stratum

- `N` Overall N
}\if{html}{\out{</div>}}

The evaluated value of \code{.header} is also available within \code{tbl_strata2(.tbl_fun)}}
}
\value{
a 'gtsummary' table
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}\cr
Similar to \code{tbl_strata()}, except the function accepts an ARD
instead of a data frame.
}
\examples{
cards::ADLB |>
  dplyr::filter(
    AVISIT \%in\% c("Baseline", "Week 12", "Week 24"),
    PARAMCD \%in\% c("ALB", "BUN")
  ) |>
  cards::ard_summary(
    strata = PARAM,
    by = TRTA,
    variables = AVAL
  ) |>
  tbl_ard_strata2(
    strata = c(group2, group2_level),
    ~ .x |>
      tbl_ard_summary(by = TRTA, label = list(AVAL = .y)),
    .combine_with = "tbl_stack",
    .combine_args = list(group_header = NULL)
  )
}
