## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 7,
  fig.height = 5
)

library(gvcAnalyzer)

## -----------------------------------------------------------------------------
io <- bm_build_io(
  Z = bm_toy_Z,
  Y = bm_toy_Y,
  VA = bm_toy_VA,
  X = bm_toy_X,
  countries = bm_toy_countries,
  sectors = bm_toy_sectors
)

## -----------------------------------------------------------------------------
trade_meas <- bm_2025_trade_measures(io)
trade_meas[, c("exporter", "share_GVC_trade", "share_PF_trade",
               "share_TS_trade", "share_PB_trade", "forward_trade")]

## -----------------------------------------------------------------------------
out_meas <- bm_2025_output_measures(io)
out_meas[, c("country", "share_GVC_output", "share_PF_output",
             "share_TS_output", "share_PB_output", "forward_output")]

## -----------------------------------------------------------------------------
# Standardize column names
trade_meas$country <- trade_meas$exporter

comparison <- merge(
  trade_meas[, c("country", "share_GVC_trade", "forward_trade")],
  out_meas[, c("country", "share_GVC_output", "forward_output")],
  by = "country"
)

comparison

## -----------------------------------------------------------------------------
oldpar <- par(mar = c(5, 5, 3, 2))

plot(
  comparison$share_GVC_trade,
  comparison$share_GVC_output,
  pch = 19,
  col = "darkblue",
  cex = 1.5,
  xlab = "GVC Share of Exports (Trade)",
  ylab = "GVC Share of Output (Output)",
  main = "Trade-Based vs Output-Based GVC Participation",
  xlim = c(0, max(comparison$share_GVC_trade, comparison$share_GVC_output, na.rm = TRUE) * 1.1),
  ylim = c(0, max(comparison$share_GVC_trade, comparison$share_GVC_output, na.rm = TRUE) * 1.1)
)

text(
  comparison$share_GVC_trade,
  comparison$share_GVC_output,
  labels = comparison$country,
  pos = 3,
  cex = 0.8
)

abline(a = 0, b = 1, lty = 2, col = "gray", lwd = 2)

grid()

par(oldpar)

## -----------------------------------------------------------------------------
oldpar <- par(mar = c(5, 5, 3, 2))

plot(
  comparison$forward_trade,
  comparison$forward_output,
  pch = 19,
  col = "darkgreen",
  cex = 1.5,
  xlab = "Forward Index - Exports",
  ylab = "Forward Index - Output",
  main = "Forward Orientation: Trade vs Production Perspective",
  xlim = c(-1, 1),
  ylim = c(-1, 1)
)

text(
  comparison$forward_trade,
  comparison$forward_output,
  labels = comparison$country,
  pos = 3,
  cex = 0.8
)

abline(h = 0, v = 0, lty = 2, col = "gray")

abline(a = 0, b = 1, lty = 2, col = "red", lwd = 2)

grid()

par(oldpar)

## -----------------------------------------------------------------------------
sessionInfo()

