% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.r
\name{h5_is_group}
\alias{h5_is_group}
\title{Check if an HDF5 Object is a Group}
\usage{
h5_is_group(file, name, attr = NULL)
}
\arguments{
\item{file}{The path to the HDF5 file.}

\item{name}{The full path of the object to check.}

\item{attr}{The name of an attribute. This parameter is included for consistency with other functions.
Since attributes cannot be groups, providing this will always return \code{FALSE}. (Default: \code{NULL})}
}
\value{
A logical value: \code{TRUE} if the object exists and is a group,
\code{FALSE} otherwise (if it is a dataset, or does not exist).
}
\description{
Checks if the object at a given path is a group.
}
\examples{
file <- tempfile(fileext = ".h5")

h5_create_group(file, "grp")
h5_is_group(file, "grp") # TRUE

h5_write(1:10, file, "my_ints")
h5_is_group(file, "my_ints") # FALSE

unlink(file)
}
\seealso{
\code{\link[=h5_is_dataset]{h5_is_dataset()}}, \code{\link[=h5_exists]{h5_exists()}}
}
