% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropy.R
\name{entropy_2d}
\alias{entropy_2d}
\title{2D Entropy}
\usage{
entropy_2d(data, bw, grid_size, relative = FALSE, add_max = FALSE)
}
\arguments{
\item{data}{data.frame with two columns for x and y coordinates.}

\item{bw}{Bandwidth to use in 2D kernel density estimator.}

\item{grid_size}{Size of binning grid, in the unit of the data.}

\item{relative}{Logical. Rescale entropy relative to the maximum entropy
given the number of grid cells? Defaults to FALSE.}

\item{add_max}{Logical. Add the maximum entropy as a return?}
}
\value{
entropy value
}
\description{
Calculates 2D entropy.
}
\examples{
dta <- data.frame(x = rnorm(100,5,1), y = rnorm(100,5,1))
entropy_2d(dta, bw = 0.5, 0.25)
entropy_2d(dta, bw = 0.5, 0.25, relative = TRUE)
dta <- data.frame(x = runif(100, 1,10), y = runif(100, 1,10))
entropy_2d(dta, bw = 0.5, 0.25)
entropy_2d(dta, bw = 0.5, 0.25, relative = TRUE)
}
\references{
X. Liu, Q. Ma, X. Wu, T. Hu, Z. Liu, L. Liu, Q. Guo, Y. Su (2022). A novel entropy-based method to quantify forest canopy structural complexity from multiplatform lidar point clouds. Remote Sens. Environ. 282, 113280.
}
