% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_complexities.R
\name{calculate_complexities}
\alias{calculate_complexities}
\title{Calculate Distribution of Complexities by Sample}
\usage{
calculate_complexities(x, cutoff, control, sample, gene, perc_susc)
}
\arguments{
\item{x}{a \code{data.frame} containing the data.}

\item{cutoff}{value for percent susceptible cutoff. \code{Numeric}.}

\item{control}{value used to denote the susceptible control in the \code{gene}
column. \code{Character}.}

\item{sample}{column providing the unique identification for each sample
being tested. \code{Character}.}

\item{gene}{column providing the gene(s) being tested. \code{Character}.}

\item{perc_susc}{column providing the percent susceptible reactions.
\code{Character}.}
}
\value{
An object of class \code{hagis.complexities}.

An object of class \code{hagis.complexities} is a \code{list} containing the following
components
\describe{
\item{grouped_complexities}{a \code{\link[data.table:data.table]{data.table::data.table()}} object of
grouped complexities}
\item{individual_complexities}{a \code{\link[data.table:data.table]{data.table::data.table()}} object of
individual complexities}
}
}
\description{
Calculate the distribution of susceptibilities by sample id.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}

# Using the built-in data set, `P_sojae_survey`
data(P_sojae_survey)

P_sojae_survey

# calculate susceptibilities with a 60 \% cutoff value
complexities <- calculate_complexities(
  x = P_sojae_survey,
  cutoff = 60,
  control = "susceptible",
  sample = "Isolate",
  gene = "Rps",
  perc_susc = "perc.susc"
)
complexities

summary(complexities)
\dontshow{\}) # examplesIf}
}
