% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hahmmr.R
\name{run_allele_hmm_s5}
\alias{run_allele_hmm_s5}
\title{Run a 5-state allele-only HMM - two theta levels}
\usage{
run_allele_hmm_s5(
  pAD,
  DP,
  p_s,
  t = 1e-05,
  theta_min = 0.08,
  gamma = 20,
  prior = NULL,
  ...
)
}
\arguments{
\item{pAD}{integer vector Paternal allele counts}

\item{DP}{integer vector Total alelle counts}

\item{p_s}{numeric vector Phase switch probabilities}

\item{t}{numeric Transition probability between copy number states}

\item{theta_min}{numeric Minimum haplotype frequency deviation threshold}

\item{gamma}{numeric Overdispersion in the allele-specific expression}

\item{prior}{numeric vector Prior probabilities for each state}

\item{...}{Additional parameters}
}
\value{
character vector Decoded states
}
\description{
Run a 5-state allele-only HMM - two theta levels
}
\examples{
with(bulk_example, {
    run_allele_hmm_s5(pAD = pAD, DP = DP, R = R, p_s = p_s, theta_min = 0.08, gamma = 30)
})
}
