% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slrs.R
\name{get_rates_of_misleading_slrs}
\alias{get_rates_of_misleading_slrs}
\title{Get Rates of Misleading Evidence for SLRs}
\usage{
get_rates_of_misleading_slrs(df, threshold = 1)
}
\arguments{
\item{df}{A dataframe of SLRs from \code{\link{compare_writer_profiles}} with
\code{score_only = FALSE}.}

\item{threshold}{A number greater than zero that serves as a decision
threshold. If the ground truth for two documents is that they came from the
same writer and the SLR is less than the decision threshold, this is
misleading evidence that incorrectly supports the defense (false negative).
If the ground truth for two documents is that they came from different
writers and the SLR is greater than the decision threshold, this is
misleading evidence that incorrectly supports the prosecution (false
positive).}
}
\value{
A list
}
\description{
Calculate the rates of misleading evidence for score-based likelihood ratios
(SLRs) when the ground truth is known.
}
\examples{
\donttest{
comparisons <- compare_writer_profiles(test, score_only = FALSE)
get_rates_of_misleading_slrs(comparisons)
}

}
