% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcp_cf_arima.R
\name{hcp_cf_arima}
\alias{hcp_cf_arima}
\title{Change Finder using ARIMA}
\usage{
hcp_cf_arima(sw_size = NULL)
}
\arguments{
\item{sw_size}{Integer. Sliding window size for smoothing/statistics.}
}
\value{
\code{hcp_cf_arima} object.
}
\description{
Change-point detection by modeling residual deviations with ARIMA and applying
a second-stage smoothing and thresholding, inspired by ChangeFinder
\url{doi:10.1109/TKDE.2006.1599387}. Wraps ARIMA from the \code{forecast} package.
}
\examples{
library(daltoolbox)

# Load change-point example data
data(examples_changepoints)

# Use a simple example
dataset <- examples_changepoints$simple
head(dataset)

# Configure ChangeFinder-ARIMA detector
model <- hcp_cf_arima()

# Fit the model
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Show detected change points
print(detection[(detection$event),])

}
\references{
\itemize{
\item Takeuchi J, Yamanishi K (2006). A unifying framework for detecting outliers and
change points from time series. IEEE Transactions on Knowledge and Data Engineering.
}
}
