% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_hbm.R
\name{update_hbm}
\alias{update_hbm}
\title{update_hbm : Update a Hierarchical Bayesian Model (hbm) object}
\usage{
update_hbm(
  model,
  newdata = NULL,
  iter = NULL,
  warmup = NULL,
  chains = NULL,
  cores = NULL,
  control = NULL,
  ...
)
}
\arguments{
\item{model}{A \code{brmsfit}/\code{hbmfit} object}

\item{newdata}{(optional) A new dataset with the same structure as the original}

\item{iter}{(optional) Number of MCMC iterations}

\item{warmup}{(optional) Number of warmup iterations}

\item{chains}{(optional) Number of MCMC chains}

\item{cores}{(optional) Number of cores to use for sampling}

\item{control}{(optional) A named list of control parameters passed to Stan}

\item{...}{Other arguments passed to \code{update.brmsfit}, except those modifying model structure}
}
\value{
An updated \code{hbmfit} object
}
\description{
This function updates an existing hbmfit object generated by \code{hbm()}, \code{hbm_beta()}, \code{hbm_logitnormal()}, and \code{hbm_lognormal()}.
It allows updating the formula, data, and other arguments, following the behavior of \code{brms::update()}.
}
\details{
Update a Hierarchical Bayesian Model (hbm) object
}
\examples{
\donttest{
library(hbsaems)
# Load example data
data("data_fhnorm")
# Fit initial model
model <- hbm(
formula = bf(y ~ x1 + x2 + x3),
hb_sampling = "gaussian",
hb_link = "identity",
data = data_fhnorm,
chains = 2,
iter = 10000,
warmup = 2000,
cores = 2
 )
# Update number of  iterations and warmup
updated_model <- update_hbm(
model,
newdata = data_fhnorm,
iter = 10000,
warmup = 2000,
 chains = 2,
 cores = 2
 )
# Check updated model summary
summary(updated_model)
  }
}
