% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdcate_main_operators.R
\name{HDCATE.set_first_stage}
\alias{HDCATE.set_first_stage}
\title{Set user-defined first-stage estimating methods}
\usage{
HDCATE.set_first_stage(
  model,
  fit.treated,
  fit.untreated,
  fit.propensity,
  predict.treated,
  predict.untreated,
  predict.propensity
)
}
\arguments{
\item{model}{an object created via \link{HDCATE}}

\item{fit.treated}{function that accepts a data.frame as the only argument, fits the treated expectation function, and returns a fitted object}

\item{fit.untreated}{function that accepts a data.frame as the only argument, fits the untreated expectation function, and returns a fitted object}

\item{fit.propensity}{function that accepts a data.frame as the only argument, fits the propensity function, and return a fitted object}

\item{predict.treated}{function that accepts the returned object of \code{fit.treated} and a data.frame as arguments, and returns the predicted vector of that data.frame}

\item{predict.untreated}{function that accepts the returned object of \code{fit.untreated} and a data.frame as arguments, and returns the predicted vector that data.frame}

\item{predict.propensity}{function that accepts the returned object of \code{fit.propensity} and a data.frame as arguments, and returns the predicted vector that data.frame}
}
\value{
None.
}
\description{
Set user-defined ML methods (such as random forests, elastic-net, boosting) to run the first-stage estimation.
}
\examples{
# get simulation data
n_obs <- 500  # Num of observations
n_var <- 100  # Num of observed variables
n_rel_var <- 4  # Num of relevant variables
data <- HDCATE.get_sim_data(n_obs, n_var, n_rel_var)
# conditional expectation model is misspecified
x_formula <- paste(paste0('X', c(2:n_var)), collapse ='+')
# propensity score model is misspecified
# x_formula <- paste(paste0('X', c(1:(n_var-1))), collapse ='+')

# create a new HDCATE model
model <- HDCATE(data=data, y_name='Y', d_name='D', x_formula=x_formula)

# manually define a lasso method
my_lasso_fit_exp <- function(df) {
  hdm::rlasso(as.formula(paste0('Y', "~", x_formula)), df)
}
my_lasso_predict_exp <- function(fitted_model, df) {
  predict(fitted_model, df)
}
my_lasso_fit_ps <- function(df) {
  hdm::rlassologit(as.formula(paste0('D', "~", x_formula)), df)
}
my_lasso_predict_ps <- function(fitted_model, df) {
  predict(fitted_model, df, type="response")
}

# Apply the "my-lasso" apporach to the first stage
HDCATE.set_first_stage(
  model,
  my_lasso_fit_exp,
  my_lasso_fit_exp,
  my_lasso_fit_ps,
  my_lasso_predict_exp,
  my_lasso_predict_exp,
  my_lasso_predict_ps
)

}
