% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pulse_read.R
\name{pulse_read}
\alias{pulse_read}
\title{(\verb{STEP 1}) Read data from all PULSE files in the target folder}
\usage{
pulse_read(paths, msg = TRUE)
}
\arguments{
\item{paths}{character vectors, containing file paths to CSV files produced by a PULSE system during a single experiment.}

\item{msg}{logical, defaults to \code{TRUE}; should non-crucial messages (but not errors) be shown (mostly for use from within the wrapper function \code{PULSE()}, where it is set to \code{FALSE} to avoid the repetition of identical messages)}
}
\value{
A list with four elements:
\itemize{
\item \verb{$data} , tibble containing all data from all PULSE files
\item \verb{$multi}, logical indicating if the data is from a multi-channel system (TRUE) or from a one-channel system (FALSE)
\item \verb{$vrsn} , numeric value representing the version number of the PULSE system where the data was generated
\item \verb{$freq} , numeric value representing the sampling frequency used (in Hz)
}
}
\description{
\itemize{
\item \strong{\verb{-->>} step 1 -- \code{\link[=pulse_read]{pulse_read()}} \verb{<<--}}
\item \verb{step 2} -- \code{\link[=pulse_split]{pulse_split()}}
\item \verb{step 3} -- \code{\link[=pulse_optimize]{pulse_optimize()}}
\item \verb{step 4} -- \code{\link[=pulse_heart]{pulse_heart()}}
\item \verb{step 5} -- \code{\link[=pulse_doublecheck]{pulse_doublecheck()}}
\item \verb{step 6} -- \code{\link[=pulse_choose_keep]{pulse_choose_keep()}}
}

Importing data from PULSE \code{'.csv'} files is the first step of the analysis of PULSE data.

\code{pulse_read()} checks that the paths provided by the user conform to certain expectations and then reads the data from all files and merges into a single tibble. Only data from the same experiment should be read at the same time (i.e., with the same channel names, collected with the same sampling frequency, and produced using a PULSE multi-channel or a PULSE one-channel system running the same firmware version throughout the experiment). To put it differently, one call to \code{pulse_read()} can only read files where the header is absolutely invariant, and only the data portion of the files differs. The output of \code{pulse_read()} can be directly passed on to \code{pulse_split()}.
}
\section{Time zones}{

PULSE systems \strong{ALWAYS} record data using \strong{UTC +0}. This is intentional! If data were to be recorded using local time zones, issues with daylight saving time, leap seconds, etc. could spoil the dataset. Worse, should the information about which time zone had been used get lost or accidentally modified, the validity of the entire dataset could be compromised. By always using UTC +0 all these issues are minimized and the processing pipeline becomes vastly easier and more efficient. Still, this means that after the data has been processed using the \code{\link{heartbeatr-package}}, the user may need to adjust the time zone of all timestamps so that the timing matches other information relative to the experiment.
}

\examples{
## Begin prepare data ----
paths <- pulse_example()
## End prepare data ----

pulse_read(paths)
}
\seealso{
\itemize{
\item \code{\link[=pulse_split]{pulse_split()}}, \code{\link[=pulse_optimize]{pulse_optimize()}}, \code{\link[=pulse_heart]{pulse_heart()}}, \code{\link[=pulse_doublecheck]{pulse_doublecheck()}} and \code{\link[=pulse_choose_keep]{pulse_choose_keep()}} are the other functions needed for the complete PULSE processing workflow
\item \code{\link[=PULSE]{PULSE()}} is a wrapper function that executes all the steps needed to process PULSE data at once
}
}
