% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pulse_heart.R
\name{pulse_halve}
\alias{pulse_halve}
\title{Halves heart beat frequencies computed by \code{pulse_heart}}
\usage{
pulse_halve(hr)
}
\arguments{
\item{hr}{a tibble as the one used as input to \code{\link[=pulse_doublecheck]{pulse_doublecheck()}}, but with the additional column \code{d_f}, which flags rows where heart beat frequencies need to be halved. All rows supplied are halved, so input should be a filtered version of the full dataset.}
}
\value{
A tibble with as many rows as the one provided as input, but with \code{data}, \code{hz}, \code{n}, \code{sd}, and \code{ci} adjusted accordingly.
}
\description{
Halves the heart beat frequency computed by \code{pulse_heart} when double peaks have been detected by \code{pulse_correct}. Note that the correction cannot be reverted (if just testing, store as a different variable). The associated stats are recalculated. This function is used by \code{pulse_correct}, it is not immediately usable as standalone.
}
\seealso{
\itemize{
\item \code{\link[=pulse_doublecheck]{pulse_doublecheck()}} is the function within the \code{\link{heartbeatr-package}} that uses \code{pulse_halve}
\item \code{\link[=PULSE]{PULSE()}} is a wrapper function that executes all the steps needed to process PULSE data at once, including the identification and correction of possible heart rate doublings
}
}
