% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pulse_plot.R
\name{pulse_plot}
\alias{pulse_plot}
\title{Plot processed PULSE data}
\usage{
pulse_plot(
  heart_rates,
  ID = NULL,
  normalized = FALSE,
  smooth = TRUE,
  points = TRUE,
  facets = TRUE,
  bpm = FALSE
)
}
\arguments{
\item{heart_rates}{the output from \code{\link[=PULSE]{PULSE()}} (or \code{\link[=pulse_heart]{pulse_heart()}} and any of the downstream functions).}

\item{ID}{character string naming a single target channel id (must match exactly); defaults to \code{NULL}, which results in all IDs being plotted}

\item{normalized}{logical, defaults to \code{FALSE}; whether to plot \code{hz_norm} (\code{TRUE}) or \code{hz} (\code{FALSE}).}

\item{smooth}{logical, defaults to \code{TRUE}; whether to plot a \code{loess} smoothing curve (\code{TRUE}) or a line (\code{FALSE}).}

\item{points}{logical, defaults to \code{TRUE}; whether to overlay data points.}

\item{facets}{logical, defaults to \code{TRUE}; whether to separate channels in facets (\code{TRUE}) or to plot all data together (\code{FALSE})}

\item{bpm}{logical, defaults to \code{FALSE}; whether to plot heartbeat frequency using Hz (\code{FALSE}) or Beats Per Minute (\code{TRUE}); forced to \code{FALSE} if \code{normalized} is set to \code{TRUE}}
}
\value{
A ggplot object that can be augmented using ggplot2 syntax or plotted right away
}
\description{
A shortcut function based on \code{ggplot2} to facilitate the quick inspection of the results of the analysis (with the option to separate channels or not).
}
\details{
This function is \strong{NOT meant} for high-level displaying of PULSE data - it's simply a quick shortcut to facilitate data inspection.

When inspecting the plot with \code{smooth = TRUE}, assess if the \code{loess} confidence intervals are too wide for any given channel, which is indicative of data with high variability (not ideal).

If using \code{smooth = FALSE}, then look for the width of the confidence interval for each data point.
}
\examples{
## Begin prepare data ----
paths <- pulse_example()
chn <- paste0("c", formatC(1:10, width = 2, flag = "0"))
heart_rates <- PULSE(
  paths,
  discard_channels  = chn[-9],
  raw_v_smoothed = FALSE,
  show_progress = FALSE)
## End prepare data ----

# Default
pulse_plot(heart_rates)

# A single ID
pulse_plot(heart_rates, ID = "c09")

# Without facets, the different basal heartbeat rates become evident in #' non-normalized data
pulse_plot(heart_rates, facets = FALSE)

# Without facets, normalized data always lines up (around 1) during the #' baseline period
pulse_plot(
  pulse_normalize(heart_rates),
  normalized = TRUE,
  facets = FALSE)

# The plot can be modified using ggplot2 syntax
pulse_plot(heart_rates) + ggplot2::theme_dark()

# Data can also be visualized using BPM (Beats Per Minute)
pulse_plot(heart_rates, bpm = TRUE)

# If inspecting the heart rate estimates for a single ID and suppressing the
# LOESS smoothing, the confidence interval of each estimate is also shown
pulse_plot(heart_rates, ID = "c09", smooth = FALSE)
}
\seealso{
\itemize{
\item use \code{\link[=pulse_plot_raw]{pulse_plot_raw()}} to quickly plot the raw PULSE data for a given channel/split window
\item \code{\link[=PULSE]{PULSE()}} (or \code{\link[=pulse_heart]{pulse_heart()}} and any of the downstream functions) generates the input for \code{pulse_plot}
\item call \code{\link[=pulse_normalize]{pulse_normalize()}} to anchor heart beat data from each channel to a reference period during the experiment
}
}
