% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moments_estimator.R
\name{moments_estimator}
\alias{moments_estimator}
\title{Moments Estimator}
\usage{
moments_estimator(data, k, na.rm = FALSE, eps = 1e-12)
}
\arguments{
\item{data}{A numeric vector of i.i.d. observations.}

\item{k}{An integer specifying the number of top order statistics to use
(the size of the tail). Must be strictly less than the sample size.}

\item{na.rm}{Logical. If \code{TRUE}, missing values (\code{NA}) are removed
before analysis. Defaults to \code{FALSE}.}

\item{eps}{numeric, factor added to the denominator to avoid division by zero. Default value is 1e-12.}
}
\value{
A single numeric scalar: Moments estimator calculation of the shape parameter \eqn{\xi}.
}
\description{
Moments estimator to calculate \eqn{\xi} for the input data.
}
\details{
\deqn{\hat \xi_{ME} = \underbrace{\hat \xi_{k,n}^{H,1}}_{T_1} + \underbrace{1 - \frac{1}{2}(1-\frac{(\hat \xi_{k,n}^{H,1})^2}{\hat \xi_{k,n}^{H,2}})^{-1}}_{T_2}}
}
\examples{

xmin <- 1
alpha <- 2
r <- runif(800, 0, 1)
x <- (xmin * r^(-1/(alpha)))
moments <- moments_estimator(data = x, k = 5)

}
\references{
Dekkers, A. L. M., Einmahl, J. H. J., & De Haan, L. (1989). A Moment Estimator for the Index of an Extreme-Value Distribution. \emph{The Annals of Statistics}, \bold{17}(4), 1833–1855. \url{http://www.jstor.org/stable/2241667}

Nair, J., Wierman, A., & Zwart, B. (2022). \emph{The Fundamentals of Heavy Tails: Properties, Emergence, and Estimation}. Cambridge University Press. (pp. 216-219) \doi{10.1017/9781009053730}
}
