% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk_replace.R
\name{bulk_replace}
\alias{bulk_replace}
\title{Bulk replace a pattern throughout multiple files.}
\usage{
bulk_replace(files, pattern, replacement, dry.run = TRUE)
}
\arguments{
\item{files}{A vector of filepaths to replace strings in.}

\item{pattern}{The character string to be replaced.}

\item{replacement}{A character string to replace all patterns with.}

\item{dry.run}{Logical -- describe the file changes that will be made
(\code{TRUE}) or make them in the specified files (\code{FALSE})?}
}
\description{
This function makes it easier to change a specific text string throughout a
number of files, allowing you to ensure you're correcting all areas of your
code at once.
}
\examples{
library(heddlr)
temp_file <- tempfile("test", fileext = ".Rmd")
temp_patt <- "#"
export_template(temp_patt, temp_file)
bulk_replace(c(temp_file), "#", "##")
bulk_replace(c(temp_file), "#", "##", dry.run = FALSE)
}
