% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_operations.R
\name{apply_af}
\alias{apply_af}
\title{Apply an Acceleration Factor}
\usage{
apply_af(dist, af, log_af = FALSE)
}
\arguments{
\item{dist}{A survival distribution.}

\item{af}{An acceleration factor to be applied.}

\item{log_af}{If \code{TRUE}, the acceleration factor is
exponentiated before being applied.}
}
\value{
A \code{surv_aft} object.
}
\description{
Proportionally increase or reduce the time to event of a
survival distribution.
}
\examples{

dist1 <- define_surv_dist(distribution = "exp", rate = .25)
aft_dist <- apply_af(dist1, 1.5)
}
