% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfr_ddm.R
\name{dfr_ddm}
\alias{dfr_ddm}
\title{Adapted Drift Detection Method (DDM) method}
\usage{
dfr_ddm(min_instances = 30, warning_level = 2, out_control_level = 3)
}
\arguments{
\item{min_instances}{The minimum number of instances before detecting change}

\item{warning_level}{Necessary level for warning zone (2 standard deviation)}

\item{out_control_level}{Necessary level for a positive drift detection}
}
\value{
\code{dfr_ddm} object
}
\description{
DDM is a concept change detection method based on the PAC learning model premise, that the learner’s error rate will decrease as the number of analysed samples increase, as long as the data distribution is stationary. \url{doi:10.1007/978-3-540-28645-5_29}.
}
\examples{
library(daltoolbox)
library(heimdall)

# This example uses an error-based drift detector with a synthetic a 
# model residual where 1 is an error and 0 is a correct prediction.

data(st_drift_examples)
data <- st_drift_examples$univariate
data$event <- NULL
data$prediction <- st_drift_examples$univariate$serie > 4

model <- dfr_ddm()

detection <- NULL
output <- list(obj=model, drift=FALSE)
for (i in 1:length(data$prediction)){
 output <- update_state(output$obj, data$prediction[i])
 if (output$drift){
   type <- 'drift'
   output$obj <- reset_state(output$obj)
 }else{
   type <- ''
 }
 detection <- rbind(detection, data.frame(idx=i, event=output$drift, type=type))
}

detection[detection$type == 'drift',]
}
