% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/broad-sense.R
\name{H2_Oakey}
\alias{H2_Oakey}
\title{Calculate Oakey's heritability from model object}
\usage{
H2_Oakey(model, target, options)
}
\arguments{
\item{model}{Model object of class \code{lmerMod/merMod} or \code{asreml}}

\item{target}{The name of the random effect for which heritability is to be calculated.}

\item{options}{NULL by default, for internal checking of model object before calculations}
}
\value{
Numeric
}
\description{
Compute heritability for genotype means using the variance–covariance matrix of the genotype BLUPs
as described by Oakey et al. (2006).
}
\details{
\deqn{H^2_{Oakey} = \frac{\sum_{i = n_z+1}^{n_g} \lambda_i}{\sum_{n_g}^{\lambda_i\neq 0}}}
where:
\itemize{
\item \eqn{n_g} is the number of genotypes
\item \eqn{n_z} is the number of zero eigenvalues
\item \eqn{\lambda_i} is the ith eigenvalue of the matrix \eqn{I_{m} - G^{-1}C^{gg}}
\item \eqn{\sigma^2} is the variance attributed to differences between genotype
}

See pages 813 and 818 of the reference for full derivation and explanation for Oakey's heritability
}
\examples{
# lme4 model
lettuce_subset <- lettuce_phenotypes |> subset(loc == "L2")
lettuce_lme4 <- lme4::lmer(y ~ rep + (1 | gen), data = lettuce_subset)
H2_Oakey(lettuce_lme4, target = "gen")

# asreml model (Requires license)
\dontrun{
lettuce_asreml <- asreml::asreml(fixed = y ~ rep,
                                 random = ~ gen,
                                 data = lettuce_subset,
                                 trace = FALSE
                                 )

H2_Oakey(lettuce_asreml, target = "gen")
}

}
\references{
Oakey, H., Verbyla, A., Pitchford, W., Cullis, B., & Kuchel, H. (2006). Joint modeling of additive and non-additive genetic line effects in single field trials. Theoretical and Applied Genetics, 113(5), 809–819. https://doi.org/10.1007/s00122-006-0333-z
}
