% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim.R
\name{crit_qEI}
\alias{crit_qEI}
\title{Parallel Expected improvement}
\usage{
crit_qEI(x, model, cst = NULL, preds = NULL)
}
\arguments{
\item{x}{matrix of new designs representing the batch of q points,
one point per row (size q x d)}

\item{model}{\code{homGP} or \code{hetGP} model, including inverse matrices.}

\item{cst}{optional plugin value used in the EI, see details}

\item{preds}{optional predictions at \code{x} to avoid recomputing if already done (must include the predictive covariance, i.e., the \code{cov} slot)}
}
\description{
Fast approximated batch-Expected Improvement criterion (for minimization)
}
\details{
\code{cst} is classically the observed minimum in the deterministic case. 
In the noisy case, the min of the predictive mean works fine.
}
\note{
This is a beta version at this point. It may work for for TP models as well.
}
\examples{
## Optimization example (noiseless)
set.seed(42)

## Test function defined in [0,1]
ftest <- f1d

n_init <- 5 # number of unique designs
X <- seq(0, 1, length.out = n_init)
X <- matrix(X, ncol = 1)
Z <- ftest(X)

## Predictive grid
ngrid <- 51
xgrid <- seq(0,1, length.out = ngrid)
Xgrid <- matrix(xgrid, ncol = 1)

model <- mleHomGP(X = X, Z = Z, lower = 0.01, upper = 1, known = list(g = 2e-8))

# Regular EI function
cst <- min(model$Z0)
EIgrid <- crit_EI(Xgrid, model, cst = cst)
plot(xgrid, EIgrid, type = "l")
abline(v = X, lty = 2) # observations

# Create batch (based on regular EI peaks)
xbatch <- matrix(c(0.37, 0.17, 0.7), 3, 1)
abline(v = xbatch, col = "red")
fqEI <- crit_qEI(xbatch, model, cst = cst)

# Compare with Monte Carlo qEI
preds <- predict(model, xbatch, xprime = xbatch)
nsim <- 1e4
simus <- matrix(rnorm(3 * nsim), nsim) \%*\% chol(preds$cov)
simus <- simus + matrix(preds$mean, nrow = nsim, ncol = 3, byrow = TRUE)
MCqEI <- mean(apply(cst - simus, 1, function(x) max(c(x, 0))))

}
\references{
M. Binois (2015), Uncertainty quantification on Pareto fronts and high-dimensional strategies in Bayesian optimization, with applications in multi-objective automotive design.
Ecole Nationale Superieure des Mines de Saint-Etienne, PhD thesis.
}
