% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_helpers.R
\name{get_parent}
\alias{get_parent}
\title{Get parent cell}
\usage{
get_parent(cell_id, grid, levels = 1L)
}
\arguments{
\item{cell_id}{Numeric vector of cell IDs}

\item{grid}{A HexGridInfo or HexData object}

\item{levels}{Number of levels up (default 1)}
}
\value{
Numeric vector of parent cell IDs
}
\description{
Returns the parent cell at a coarser resolution.
}
\examples{
grid <- hex_grid(resolution = 10)
child_cells <- lonlat_to_cell(c(0, 10), c(45, 50), grid)
parent_cells <- get_parent(child_cells, grid)
}
\keyword{internal}
