% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hub_download.R
\name{hub_download}
\alias{hub_download}
\title{Downloads files from HuggingFace repositories}
\usage{
hub_download(
  repo_id,
  filename,
  ...,
  revision = "main",
  repo_type = "model",
  local_files_only = FALSE,
  force_download = FALSE
)
}
\arguments{
\item{repo_id}{The repository identifier, eg \code{"bert-base-uncased"} or \code{"deepset/sentence_bert"}.}

\item{filename}{Filename to download from the repository. Example \code{"config.json"}.}

\item{...}{currenytly unused.}

\item{revision}{Revision (branch, tag or commitid) to download the file from.}

\item{repo_type}{The type of the repository. Currently only \code{"model"} is supported.}

\item{local_files_only}{Only use cached files?}

\item{force_download}{For re-downloading of files that are cached.}
}
\value{
The file path of the downloaded or cached file. The snapshot path is returned
as an attribute.
}
\description{
Downloads files from HuggingFace repositories
}
\examples{
try({
withr::with_envvar(c(HUGGINGFACE_HUB_CACHE = tempdir()), {
path <- hub_download("gpt2", "config.json")
print(path)
str(jsonlite::fromJSON(path))
})
})

}
