% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scca.R
\name{scca}
\alias{scca}
\title{Sparse canonical covariance analysis}
\usage{
scca(X,Y,penalty="HL",lamx=c(1,2,3),lamy=c(1,2,3),nc=1,
tuning="CV.alt",K=5,seed=NULL,center=TRUE,scale=FALSE)
}
\arguments{
\item{X}{n-by-p data matrix, where n is the number of subjects and p is the
number of variables}

\item{Y}{n-by-q data matrix, where q is the number of variables}

\item{penalty}{"HL" is the unbounded penalty proposed by Lee and Oh (2009).
"LASSO" (Tibshirani, 1996), "SCAD" (Fan and Li, 2001) and "SOFT"
(soft thresholding) are also available as other penalty options.
Default is "HL".}

\item{lamx}{A vector specifying grid points of the tuning parameter for X.
Default is (1,2,3).}

\item{lamy}{A vector specifying grid points of the tuning parameter for Y.
Default is (1,2,3).}

\item{nc}{Number of components (canonical vectors). Default is 1.}

\item{tuning}{How to find optimal tuning parameters for the sparsity.
If tuning="CV.full", then the tuning parameters are selected
automatically via K-fold cross-validation by using 2-dim'l grid search.
If "CV.alt", then a sequential 1-dim'l search method is applied instead of
the 2-dim'l grid search. Default is "CV.alt".}

\item{K}{Perform K-fold cross-validation.}

\item{seed}{Seed number for initialization. A random initial point is
generated for tuning="CV.alt".}

\item{center}{The columns of the data matrix are centered to have mean zero.
Default is TRUE.}

\item{scale}{The columns of the data matrix are scaled to have variance 1.
Default is FALSE.}
}
\value{
\itemize{
  \item A: p-by-nc matrix, k-th colum of A corresponds to k-th pattern
  \item B: q-by-nc matrix, k-th colum of B corresponds to k-th pattern
  (canonical vector) for Y
  \item U: n-by-nc matrix. k-th column of U corresponds to k-th score
  associated with k-th pattern for X
  \item V: n-by-nc matrix. k-th column of V corresponds to k-th score
  associated with k-th pattern for Y
  \item lambda: nc-by-2 matrix. k-th row of lambda corresponds to the optimal
  tuning parameters for k-th pattern pairs
  \item CR: average cross-validated sample covariance
}
}
\description{
'scca' is used to perform sparse canonical covariance analysis (SCCA)
}
\details{
Sparse CCA uses a random-effect model approach to obtain sparse
regression. This model gives unbounded gains for zero loadings at the
origin. Various penalty functions can be adapted as well.
}
\examples{
## Example 1
## A very simple simulation example
n<-10; p<-50; q<-20
X = matrix(rnorm(n*p),ncol=p)
Y = matrix(rnorm(n*q),ncol=q)
scca(X,Y)

}
\references{
Lee, W., Lee, D., Lee, Y. and Pawitan, Y. (2011) Sparse Canonical
Covariance Analysis for High-throughput Data
}
\author{
Woojoo Lee, Donghwan Lee, Youngjo Lee and Yudi Pawitan
}
