% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hill_taxa_parti.R
\name{hill_taxa_parti}
\alias{hill_taxa_parti}
\title{Decompostion of Taxonomic diversity through Hill Numbers}
\usage{
hill_taxa_parti(
  comm,
  q = 0,
  base = exp(1),
  rel_then_pool = TRUE,
  show_warning = TRUE,
  check_data = TRUE
)
}
\arguments{
\item{comm}{A data frame of vegetation data. Sites as rows, species as columns.}

\item{q}{Hill number, \code{q} = 0 (default) to get species richness,
\code{q} = 1 to get shannon entropy, \code{q} = 2 will give inverse Simpson.}

\item{base}{default is \code{exp(1)}, the base of log.}

\item{rel_then_pool}{default is \code{TRUE.} Abundance of species are first changed to relative abundance within sites,
then pooled into one assemblage. If \code{FALSE}, sites are pooled first, then change abundance of species
to relative abundance.}

\item{show_warning}{whether to print warning, default is \code{TRUE}.}

\item{check_data}{whether to check data first? Default is \code{TRUE}.}
}
\value{
A data frame with one row (across all sites), including these columns: q, gamma diversity, alpha diversity,
beta diversity, MacArthur's homogeneity measure, local similarity (species overlap, similar to Sorensen),
and region similarity (species overlap, similar to Jaccard).
See Chao, Chiu and Jost 2014 Table 2 for more information.
}
\description{
Calculate taxonomic gamma, alpha, and beta diversity across all communities, as
well as site similarity. If comm has 2 sites, this function gives pair comparison.
If comm has >2 sites, gamma diversity is the diversity of the pooled assemblage,
alpha is the average diversity across all site, beta is across all communities.
}
\examples{
dummy = FD::dummy
hill_taxa_parti(comm = dummy$abun, q = 0)
hill_taxa_parti(comm = dummy$abun, q = 1)
hill_taxa_parti(comm = dummy$abun, q = 0.9999999)
hill_taxa_parti(comm = dummy$abun, q = 0.9999999, rel_then_pool = FALSE)
hill_taxa_parti(comm = dummy$abun, q = 1, rel_then_pool = FALSE)
hill_taxa_parti(comm = dummy$abun, q = 2)
hill_taxa_parti(comm = dummy$abun, q = 3)

}
\references{
Chao, Anne, Chun-Huo Chiu, and Lou Jost. Unifying Species Diversity, Phylogenetic Diversity, Functional Diversity, and Related Similarity and Differentiation Measures Through Hill Numbers. Annual Review of Ecology, Evolution, and Systematics 45, no. 1 (2014): 297–324. <doi:10.1146/annurev-ecolsys-120213-091540>.

Jost, Lou. Entropy and diversity. Oikos 113, no. 2 (2006): 363-375. <doi:10.1111/j.2006.0030-1299.14714.x>.
}
\seealso{
\code{\link{hill_taxa}}
}
