% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routes.R
\name{find_route}
\alias{find_route}
\title{Find best route between 2 airports}
\usage{
find_route(
  ac,
  ap2,
  fat_map,
  avoid = NA,
  route_grid,
  cf_subsonic = NA,
  refuel = NA,
  refuel_h = 1,
  refuel_only_if = TRUE,
  refuel_topN = 1,
  max_circuity = 2,
  ap_loc,
  margin_km = 200,
  ...
)
}
\arguments{
\item{ac}{One aircraft, as from \code{\link{make_aircraft}}}

\item{ap2}{One airport pair, as from \code{\link{make_AP2}}}

\item{fat_map}{\code{sf::MULTIPOLYGON} map of land, including buffer}

\item{avoid}{\code{sf::MULTIPOLYGON} map of areas not to fly over}

\item{route_grid}{\code{GridLat} routing grid as from
\code{\link{make_route_grid}}}

\item{cf_subsonic}{Further aircraft to use as comparator, default NA. (use is
not recommended)}

\item{refuel}{Airports available for refuelling, dataframe with \code{APICAO,
long, lat}}

\item{refuel_h}{Duration of refuelling stop, in hours}

\item{refuel_only_if}{If TRUE (default) only test refuel options if necessary
because the great circle distance is too far for the aircraft range}

\item{refuel_topN}{Return the best N (default 1) refuelling options}

\item{max_circuity}{Threshold for excluding refuelling stops (default 2.0)}

\item{ap_loc}{Airport locations as from \code{\link{make_airports}}}

\item{margin_km}{Great circle distance between airports must be less than
aircraft range minus this operating margin (default 200km), to give
a margin for arrival and departure.}

\item{...}{Other parameters, passed to \code{\link{find_leg}} and thence to
to \code{\link{make_route_envelope}}.}
}
\value{
Dataframe with details of the route
}
\description{
\code{find_route} finds the quickest route between two airports, refuelling
if necessary
}
\details{
This function finds the quickest route between two airports. A 'route' is
made up of one or two 'legs' (airport to airport without intermediate stop).
\code{find_route} makes one or more calls to \code{find_leg} as required.

It assumes that the routing grid, \code{route_grid}, has already been
classified as land or sea using the map \code{fat_map}. The map is further
used when converting the grid-based route to one of great circles segments.
}
\section{Refuelling}{


  If either necessary, because the great circle distance is greater than the
  aircraft range, or because \code{refuel_only_if} is FALSE,
  \code{find_route} searches through a list of refuelling airports and
  chooses the quickest one (or \code{refuel_topN}).

  Circuitous refuelling is avoided, tested against total distance <
  \code{max_circuity} * great circle distance. This is separate to the limits
  placed on circuity of individual legs in \code{\link{find_leg}}.

  If no refuel option is found, a message is displayed. The route with `NA`
  for `time_h` is returned.

  Each refuelling stop costs \code{refuel_h} in addition to the time to
  descend to the airport and then to climb out again.
}

\examples{
# need to load some of the built-in data
aircraft <- make_aircraft(warn = FALSE)
# get test datasets
NZ_buffer30 <- hm_get_test("buffer")
NZ_grid <- hm_get_test("grid")
airports <- make_airports(crs = sf::st_crs(NZ_buffer30))

options("himach.verbosity" = 4) #for heavy reporting
# from Auckland to Christchurch
ap2 <- make_AP2("NZAA","NZCH",airports)
# on some CRAN machines even this takes too long, so not run
\dontrun{
routes <- find_route(aircraft[4,],
                    ap2,
                    fat_map = NZ_buffer30,
                    route_grid = NZ_grid,
                    ap_loc = airports)
}

}
