% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topmatch.R
\name{topmatch}
\alias{topmatch}
\title{A function selecting the dams and sires with the fewest genetic mismatches to an offspring}
\source{
Cockburn et al. (2020) HIPHOP: improved paternity assignment among
close relatives using a simple exclusion method for biallelic markers.
Molecular Ecology Resources, in revision.
}
\usage{
topmatch(
  x,
  ranking,
  condition = "none",
  thres = 99999,
  top = 3,
  unique = "pair"
)
}
\arguments{
\item{x}{The file with hot and hiphop scores that is generated by the 'hothiphop()' function.}

\item{ranking}{This sets the mismatch criterion in which dams and sires are ranked,
possibilities include ranking="hothiphop.parents", "hiphop", "hot.parents", hot.dam", "hot.sire", "hothiphop.dam", "hothiphop.sire".
In some situations it can be useful to supply two ranking criteria, for example to avoid ties (e.g. ranking=c("hot.dam", "hiphop))}

\item{condition}{Whether or not one wants to condition on either the social mother (condition="mother")
or social father (condition="father"). The default is condition="none" in which case all
possible dams and sires are considered as genetic parents.}

\item{thres}{Sets a threshold value for the number of mismatches, if parents have less mismatches
then the variable below.threshold in the output will have a value of 1.
If 0>=thres<1, the number of mismatches will be re-expressed as a proportion of all loci sampled (not NA).
If -1>thres<0  the mismatch scores are expressed as the number of mismatched divided by the number of loci at which the offspring is heterozygote (for the HIPHOP test) or divided by  number of loci at which the offspring is homozygote (for the HOT test). This standardization may be sometimes useful for the recalculating the HIPHOP score to account for the fact that some offspring can be scored at more loci than others for this test.
By default thres is set to a large integer (99999).}

\item{top}{Sets the number of top matches that is shown in the output
#' @return a dataframe with for each offspring the top X (default top 3, giving 3 rows for each offspring) dam and sire combinations
and their mismatch scores according to the HOT and HIPHOP test, the number of loci this was based on,
and some additional relevant information about the social parents and potential dam and sires.
In addition to the top X offspring-dam-sire with the fewest mismatches, the scores of the social parents are also always listed
(if they were not already in the top X ranking).
#' \describe{
\item{year}{ the year or cohort that is being considered, adults can be potential dam or sire in some years, but no in others}
\item{brood}{ an identifier of the brood to which the offspring and adults belong/are associated with}
\item{offspring}{ an identifier of the offspring }
\item{rank}{ the ranking among all possible combinations of offspring and potential dams and sires, rank 1 is fewest mismatches according to criterion chosen in the function argument 'ranking' }
\item{dam}{ an identifier of the potential dam }
\item{sire}{ an identifier of the potential sire }
\item{dam.type}{ description of the type of potential dam (social parent, extra-group parent, within-group subordinate) }
\item{sire.type}{ description of the type of potential sire (social parent, extra-group parent, within-group subordinate) }
\item{hothiphop.parents}{ the sum of the hiphop and hot.parents mismatch score }
\item{hiphop}{ the hiphop mismatch score of the offspring with the potential dam and potential sire, expressed as the number of loci giving mismatches }
\item{hot.parents}{ the hot score of the offspring with both the potential dam and sire, expressed as the number of loci giving mismatches}
\item{hot.dam}{ the hot score of the offspring with the potential dam, expressed as the number of loci giving mismatches}
\item{hot.sire}{ the hot mismatch score of the offspring with the potential sire , expressed as the number of loci giving mismatches}
\item{hothiphop.dam}{ the sum of the hot.dam and hiphop mismatch score }
\item{hothiphop.sire}{ the sum of the hot.sire and hiphop mismatch score }
\item{below.threshold}{ if the score chosen in argument 'ranking' is below the chose threshold value, then equals to 1, else 0 }
\item{threshold}{ the chosen threshold value in argument 'threshold'}
\item{loci.dyad.dam}{ the number of loci at which both the offspring and dam were not NA }
\item{loci.dyad.sire}{the number of loci at which both the offspring and sire were not NA }
\item{loci.triad}{ the number of loci at which the offspring, dam and sire were not NA }
\item{offspring.heterozygosity}{ the proportion of loci at which the offspring was heterozygous }
\item{social.mother.sampled}{if the social.mother genotypic data is in the genotypes file then equal to 1, else 0}
\item{social.father.sampled}{if the social.father genotypic data is in the genotypes file then equal to 1, else 0}
\item{social.mother}{ identity of the social mother of the offspring}
\item{social.father}{ identity of the social father of the offspring}
\item{condition}{ the value of the argument 'condition'}
\item{ranking}{ the value of the (first) value in the argument 'ranking'}
\item{ranking2}{ the value of the second value in the argument 'ranking'}
}}

\item{unique}{When using the ranking criteria hot.dam or hot.sire the best ranked dam or sire will occupy the entire top 3 and
this does not allow comparing among dams. By setting unique to "dam" (or "sire") the output shows the
top 3 with the best record for each unique dam (or sire).}
}
\description{
This function summarizes per offspring the top combinations of dam and sire
that have the least genetic mismatches according to the hot (Huisman 2017) and/or hiphop (Cockburn et al. in revision) test criteria.
In addition to the top matched combinations the summary always also list the social parent, if not among the top X.
The user can choose whether one wants to look for the most likely dam and sire with and without
assuming that the social mother (or father) is the genetic parent. Furthermore, one can choose on which
test score to rank individuals. For more information and worked examples, see the vignette and Cockburn et al. (in revision).
}
\examples{
results<-hothiphop(ind=individuals[1:22,], gen=genotypes)
best<-topmatch(x=results, ranking="hothiphop.parents")
head(best)
}
\references{
Cockburn et al. (2020) HIPHOP: improved paternity assignment among close relatives using a simple exclusion method for biallelic markers.
Molecular Ecology Resources, in revision.

Huisman, J. (2017). Pedigree reconstruction from SNP data: parentage assignment, sibship clustering and beyond. Molecular ecology resources, 17(5), 1009-1024.
}
\author{
Martijn van de Pol, \email{martijn@myscience.eu}
}
