% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hbl_ess.R
\name{hbl_ess}
\alias{hbl_ess}
\title{Effective sample size (ESS)}
\usage{
hbl_ess(
  mcmc_pool,
  mcmc_hierarchical,
  data,
  response = "response",
  study = "study",
  study_reference = max(data[[study]]),
  group = "group",
  group_reference = min(data[[group]]),
  patient = "patient",
  rep = "rep",
  rep_reference = min(data[[rep]])
)
}
\arguments{
\item{mcmc_pool}{A fitted model from \code{\link[=hbl_mcmc_pool]{hbl_mcmc_pool()}}.}

\item{mcmc_hierarchical}{A fitted model from \code{\link[=hbl_mcmc_hierarchical]{hbl_mcmc_hierarchical()}}.}

\item{data}{A tidy data frame or \code{tibble} with the data.}

\item{response}{Character of length 1,
name of the column in \code{data} with the response/outcome variable.
\code{data[[response]]} must be a continuous variable,
and it \emph{should} be the change from baseline of a
clinical endpoint of interest, as opposed to just
the raw response. Treatment differences
are computed directly from this scale, please supply
change from baseline unless you are absolutely certain
that treatment differences computed directly from
this quantity are clinically meaningful.}

\item{study}{Character of length 1,
name of the column in \code{data} with the study ID.}

\item{study_reference}{Atomic of length 1,
element of the \code{study} column that indicates
the current study.
(The other studies are historical studies.)}

\item{group}{Character of length 1,
name of the column in \code{data} with the group ID.}

\item{group_reference}{Atomic of length 1,
element of the \code{group} column that indicates
the control group.
(The other groups may be treatment groups.)}

\item{patient}{Character of length 1,
name of the column in \code{data} with the patient ID.}

\item{rep}{Character of length 1,
name of the column in \code{data} with the rep ID.}

\item{rep_reference}{Atomic of length 1,
element of the \code{rep} column that indicates
baseline, i.e. the first rep chronologically.
(The other reps may be post-baseline study visits or time points.)}
}
\value{
A data frame with one row per discrete time point ("rep")
and the following columns:
\itemize{
\item \code{v0}: posterior predictive variance of the control group mean of a
hypothetical new study given the pooled model.
Calculated as the mean over MCMC samples of \code{1 / sum(sigma_i ^ 2)},
where each \code{sigma_i} is the residual standard deviation of
study \code{i} estimated from the pooled model.
\item \code{v_tau}: posterior predictive variance of a hypothetical
new control group mean under the hierarchical model.
Calculated by averaging over predictive draws,
where each predictive draw is from
\code{rnorm(n = 1, mean = mu_, sd = tau_)} and \code{mu_} and \code{tau_} are the
\code{mu} and \code{tau} components of an MCMC sample.
\item \code{n}: number of non-missing historical control patients.
\item \code{weight}: strength of borrowing as a ratio of variances: \code{v0 / v_tau}.
\item \code{ess}: strength of borrowing as a prior effective sample size:
\verb{n v0 / v_tau}, where \code{n} is the number of non-missing historical
control patients.
}
}
\description{
Quantify borrowing with effective sample size (ESS)
as cited and explained in the methods vignette at
\url{https://wlandau.github.io/historicalborrowlong/articles/methods.html}.
}
\examples{
  set.seed(0)
  data <- hbl_sim_independent(n_continuous = 2)$data
  data$group <- sprintf("group\%s", data$group)
  data$study <- sprintf("study\%s", data$study)
  data$rep <- sprintf("rep\%s", data$rep)
  tmp <- utils::capture.output(
    suppressWarnings(
      pool <- hbl_mcmc_pool(
        data,
        chains = 1,
        warmup = 10,
        iter = 20,
        seed = 0
      )
    )
  )
  tmp <- utils::capture.output(
    suppressWarnings(
      hierarchical <- hbl_mcmc_hierarchical(
        data,
        chains = 1,
        warmup = 10,
        iter = 20,
        seed = 0
      )
    )
  )
  hbl_ess(
    mcmc_pool = pool,
    mcmc_hierarchical = hierarchical,
    data = data
  )
}
\seealso{
Other summary: 
\code{\link{hbl_summary}()}
}
\concept{summary}
