% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{get_dataset_data}
\alias{get_dataset_data}
\title{Get data from the dataset}
\usage{
get_dataset_data(
  dataset_id,
  token = Sys.getenv("HLIDAC_TOKEN"),
  query = NULL,
  page = 1,
  sort = NULL,
  desc = NULL
)
}
\arguments{
\item{dataset_id}{ID of dataset}

\item{token}{Authorization token}

\item{query}{Search query}

\item{page}{Number of page (Please note that if the page parameter exceeds 200, the function returns error)}

\item{sort}{Sort by column}

\item{desc}{Descending or ascending sorting}
}
\value{
list containing 3 elements:
- total: Total number of datasets available (integer)
- page: Page of the result (integer), equal to the `page` argument of the function
- results: Data.frame with data, columns vary depending on the dataset
}
\description{
Get data from the dataset
}
\examples{
\dontrun{
get_dataset_data("ministri")
get_dataset_data("ministri", query = "Zeman", page = 1)
}
}
\seealso{
\url{https://www.hlidacstatu.cz/swagger/index.html}

\url{https://www.hlidacstatu.cz/api/v1/doc}

Other Datasets: 
\code{\link{get_dataset_metadata}()},
\code{\link{get_dataset_record_detail}()},
\code{\link{get_datasets}()}
}
\concept{Datasets}
