% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genpoints.R
\name{maximin_sample}
\alias{maximin_sample}
\title{Generate Maximin Sample of Points}
\usage{
maximin_sample(points, n, reps = 1000, nms)
}
\arguments{
\item{points}{The candidate points to select from.}

\item{n}{The number of points desired in the final selection.}

\item{reps}{The number of subselections to make before returning a choice}

\item{nms}{The names of the inputs parameters of the points.}
}
\value{
A data.frame containing the maximin subset.
}
\description{
Create a maximin sample from a collection of valid points
}
\details{
The point proposal methods in \code{\link{generate_new_design}} can have some
undesirable properties; particularly over-representation of the boundary of
the non-implausible space. This function attempts to find an 'optimal' space-
filling design, using the maximin criteria. A subset of the candidate points
are selected and the minimum distance between any pair of points is selected;
the subset of points which maximises this measure is returned.
}
