% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_levenshtein_holland.R
\name{con_levenshtein_holland}
\alias{con_levenshtein_holland}
\title{Congruence Index based on the Levenshtein distance}
\usage{
con_levenshtein_holland(a, b, costs = "hexa", weights = c(1.5, 1.25, 1))
}
\arguments{
\item{a}{a character vector with person Holland codes.}

\item{b}{a character vector with environment Holland codes.}

\item{costs}{character with default set to \code{costs = "hexa"} to use a matrix with replacement costs based on the RIASEC structure for the calculation of the distance.}

\item{weights}{a numeric vector with length equal to \code{a} and \code{b} assigning a weight to the places (1:6) of the letter-codes defined in \code{a} and \code{b}.}
}
\value{
a numeric with value for congruence.
}
\description{
The function computes the location-weighted, cost-sensitive (referring to the hexagon relationships) Levenshtein distance (Levenshtein, 1966) see also Needleman & Wunsch (1970).
}
\details{
The function finds the distance according to Levenshtein (1966) between two sequences (see Abbott, 1995), which are the Holland codes given in argument a, which is the person code, and argument b, which is the environment code. Computational details can be found in Needleman & Wunsch, (1970).
}
\examples{
con_levenshtein_holland(a="RIA",b="SEC") # max. difference 
con_levenshtein_holland(a="RIA",b="RIA") # max. similarity
# with 6 characters in Holland-code
w <- c(1.5,1.25,1,0.75,0.5,0.25)
con_levenshtein_holland(a="RIASEC",b="SECRIA", weights=w) # max. difference
}
\references{
Holland, J.L. 1963. A theory of vocational choice. I. Vocational images and choice. \emph{Vocational Guidance Quarterly, 11}(4), 232–239.

Levenshtein, V. I. (1966). Binary Codes Capable of Correcting Deletions, \emph{Insertions and Reversals. Soviet Physics Doklady}, 10, 707.

Abbott, A. (1995, August). Sequence Analysis: New Methods for Old Ideas. \emph{Annual Review of Sociology}, 21, 93–113.

Needleman, S. B., & Wunsch, C. D. (1970). A general method applicable to the search for similarities in the amino acid sequence of two proteins. \emph{Journal of Molecular Biology, 48}(3), 443–453. http://doi.org/10.1016/0022-2836(70)90057-4
}
\keyword{congruence}
