% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kp_historical_tables.R
\name{kp_conf}
\alias{kp_conf}
\title{\strong{Get KenPom's conference-wide stats}}
\usage{
kp_conf(year, conf)
}
\arguments{
\item{year}{Year (YYYY)}

\item{conf}{Used to limit to players in a specific conference. Allowed values are: 'A10', 'ACC', 'AE', 'AMER', \cr
'ASUN', 'B10', 'B12', 'BE', 'BSKY', 'BSTH', 'BW', 'CAA', 'CUSA', 'HORZ', 'IND', IVY', \cr
'MAAC', 'MAC', 'MEAC', 'MVC', 'MWC', 'NEC', 'OVC', 'P12', 'PAT', 'SB', 'SC', 'SEC', 'SLND', \cr
'SUM', 'SWAC', 'WAC', 'WCC'. \cr
If you try to use a conference that doesn't exist for a given season, like 'IND' and '2018', \cr
you'll get an empty table, as kenpom.com doesn't serve 404 pages for invalid table queries like that.\cr
No filter applied by default.}
}
\value{
A list of named data frames:

\strong{Standings}\tabular{ll}{
   col_name \tab types \cr
   team \tab character \cr
   overall \tab character \cr
   conf \tab character \cr
   adj_em \tab numeric \cr
   adj_em_rk \tab numeric \cr
   adj_o \tab numeric \cr
   adj_o_rk \tab numeric \cr
   adj_d \tab numeric \cr
   adj_d_rk \tab numeric \cr
   adj_t \tab numeric \cr
   adj_t_rk \tab numeric \cr
   conf_sos \tab numeric \cr
   conf_sos_rk \tab numeric \cr
   next_game \tab character \cr
   year \tab numeric \cr
}


\strong{ConferencePlayOffense}\tabular{ll}{
   col_name \tab types \cr
   team \tab character \cr
   oe \tab numeric \cr
   oe_rk \tab numeric \cr
   e_fg_pct \tab numeric \cr
   e_fg_pct_rk \tab numeric \cr
   to_pct \tab numeric \cr
   to_pct_rk \tab numeric \cr
   or_pct \tab numeric \cr
   or_pct_rk \tab numeric \cr
   ft_rate \tab numeric \cr
   ft_rate_rk \tab numeric \cr
   fg_2_pct \tab numeric \cr
   fg_2_pct_rk \tab numeric \cr
   fg_3_pct \tab numeric \cr
   fg_3_pct_rk \tab numeric \cr
   ft_pct \tab numeric \cr
   ft_pct_rk \tab numeric \cr
   tempo \tab numeric \cr
   tempo_rk \tab numeric \cr
   year \tab numeric \cr
}


\strong{ConferencePlayDefense}\tabular{ll}{
   col_name \tab types \cr
   team \tab character \cr
   de \tab numeric \cr
   de_rk \tab numeric \cr
   e_fg_pct \tab numeric \cr
   e_fg_pct_rk \tab numeric \cr
   to_pct \tab numeric \cr
   to_pct_rk \tab numeric \cr
   or_pct \tab numeric \cr
   or_pct_rk \tab numeric \cr
   ft_rate \tab numeric \cr
   ft_rate_rk \tab numeric \cr
   fg_2_pct \tab numeric \cr
   fg_2_pct_rk \tab numeric \cr
   fg_3_pct \tab numeric \cr
   fg_3_pct_rk \tab numeric \cr
   blk_pct \tab numeric \cr
   blk_pct_rk \tab numeric \cr
   stl_pct \tab numeric \cr
   stl_pct_rk \tab numeric \cr
   year \tab numeric \cr
}


\strong{AllKenPom}\tabular{ll}{
   col_name \tab types \cr
   rk \tab integer \cr
   player \tab character \cr
   year \tab numeric \cr
}


\strong{ConferenceAggregateStats}\tabular{ll}{
   col_name \tab types \cr
   stat \tab character \cr
   value \tab numeric \cr
   rk \tab numeric \cr
   year \tab numeric \cr
}


\strong{WinningTrends}\tabular{ll}{
   col_name \tab types \cr
   stat \tab character \cr
   count \tab character \cr
   value \tab numeric \cr
   rk \tab numeric \cr
   year \tab numeric \cr
}


\strong{ConferenceComparison}\tabular{ll}{
   col_name \tab types \cr
   rk \tab numeric \cr
   conference \tab character \cr
   rating \tab numeric \cr
   year \tab numeric \cr
}
}
\description{
\strong{Get KenPom's conference-wide stats}
}
\examples{
\donttest{
    try(kp_conf(year = 2020, conf = 'ACC'))
}
}
\seealso{
Other KenPom Historical Functions: 
\code{\link{kp_coach_history}()},
\code{\link{kp_confhistory}()},
\code{\link{kp_confstats}()},
\code{\link{kp_pomeroy_archive_ratings}()},
\code{\link{kp_program_ratings}()},
\code{\link{kp_team_history}()}
}
\concept{KenPom Historical Functions}
\keyword{Conference}
\keyword{Stats}
