% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{opening_summary}
\alias{opening_summary}
\title{Summarize openings from exported games}
\usage{
opening_summary(games, top_n = 20)
}
\arguments{
\item{games}{Tibble returned by \code{export_games()}.}

\item{top_n}{Number of top openings to return.}
}
\value{
A tibble of the most common openings with columns for the ECO code,
opening name, and count of games.
}
\description{
Counts openings from \code{\link[=export_games]{export_games()}} output.
To include opening information, \code{opening = TRUE} in
\code{\link[=export_games]{export_games()}}.
}
\details{
Two columns are produced by \code{\link[=export_games]{export_games()}} when
\code{opening = TRUE}:
\describe{
\item{opening_name}{An opening name provided by Lichess (for example,
"Sicilian Defense" or "Queen's Gambit Declined").}
\item{opening_eco}{The ECO code associated with the opening (for example, "B20" or "D30").
ECO (Encyclopaedia of Chess Openings) codes are a standardized classification system
for chess openings.}
}
}
