% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.descriptor.r
\name{read.descriptor}
\alias{read.descriptor}
\title{Read big memory descriptor file}
\usage{
read.descriptor(descriptor, readonly)
}
\arguments{
\item{descriptor}{name of descriptor file}

\item{readonly}{\code{TRUE} by default, specifies if the object should be readonly}
}
\value{
a mvector or a mmatrix
}
\description{
Read big memory descriptor file
}
\details{
Creates a memory-mapped object by reading a 'bigmemory'-like descriptor file.
}
\examples{
A <- mmatrix("short", 10, 20)
A[] <- sample.int(200)

# create descriptor file 
dsc <- descriptor.file(A)

# linking file to other object
B <- read.descriptor(dsc, readonly = FALSE)
all(as.matrix(A) == as.matrix(B)) # TRUE

B[1:10] <- 0
all(A[1:10] == 0) # TRUE

}
\seealso{
\link{descriptor.file}
}
