% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wind_exposure.R
\name{wind_exposure}
\alias{wind_exposure}
\title{Write storm wind exposure files}
\usage{
wind_exposure(
  locations,
  start_year,
  end_year,
  wind_limit,
  wind_var,
  out_dir,
  out_type = "csv"
)
}
\arguments{
\item{locations}{Either a vector of FIPS county codes, for county-level
output, or a dataframe with columns for community identifier (\code{commun})
and associated FIPS codes (\code{fips}), for multi-county community output.
See the examples for the proper format for this argument.}

\item{start_year}{Four-digit integer with first year to consider.}

\item{end_year}{Four-digit integer with last year to consider.}

\item{wind_limit}{Vector giving the wind speed (in m / s) to use as a
threshold for classifying a county as "exposed" to a specific storm.}

\item{wind_var}{A character string giving the wind variable to use. Choices
are \code{"vmax_sust"} (maximum sustained winds; default), \code{"vmax_gust"}
(maximum gust winds), \code{"sust_dur"} (minutes of sustained winds of 20 m / s
or higher) and \code{"gust_dur"} (minutes of gust winds of 20 m / s or higher).
If the Extended Best Tracks wind radii are used as the source of wind data,
the \code{"gust_dur"} option cannot be selected.}

\item{out_dir}{Character string giving the pathname of the directory in which
to write output. This directory should already exist on your computer.}

\item{out_type}{Character string giving the type of output files you'd like.
Options are \code{"csv"} (default) and \code{"rds"}.}
}
\value{
Writes out a directory with rain exposure files for each county or
   community indicated. For more on the columns in this output, see the
   documentation for \code{\link{county_wind}} and
   \code{\link{multi_county_wind}}.
}
\description{
This function takes an input of locations (either a vector of county FIPS
or a dataframe of multi-county FIPS, with all FIPS listed for each county)
and creates time series dataframes that can be merged with health time series,
giving the dates and exposures for all storms meeting the given
storm wind criteria.
}
\note{
This function allows you to use different wind variables (sustained winds, which
   is the default; gust winds; duration of sustained winds; duration of gust winds)
   when pulling exposures by county. However, if pulling multi-county communities,
   currently only the sustained winds metric can be used with this function.
}
\examples{
\dontrun{
# Ensure that data package is available before running the example.
#  If it is not, see the `hurricaneexposure` package vignette for details
# on installing the required data package.
if (requireNamespace("hurricaneexposuredata", quietly = TRUE)) {

# You will need a directory named "tmp" in your home directory to
# run these examples.

# By county
wind_exposure(locations = c("22071", "51700"),
              start_year = 1988, end_year = 2005,
              wind_limit = 10,
              out_dir = "~/tmp/storms")

# For multi-county communities
communities <- data.frame(community_name = c(rep("ny", 6), "no", "new"),
                          fips = c("36005", "36047", "36061",
                          "36085", "36081", "36119",
                          "22071", "51700"))
wind_exposure(locations = communities,
              start_year = 1988, end_year = 2005,
              wind_limit = 10,
              out_dir = "~/tmp/storms")
}
}
}
