% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hwe.R
\name{p_from_alpha}
\alias{p_from_alpha}
\title{Obtain gamete frequencies at equilibrium given rates of double reduction.}
\usage{
p_from_alpha(alpha, p, ploidy)
}
\arguments{
\item{alpha}{A numeric vector containing the double reduction parameter(s).
This should be a
vector of length \code{floor(ploidy/4)} where \code{alpha[i]}
is the probability of exactly \code{i} pairs of IBDR alleles
being in the gamete. Note that \code{sum(alpha)} should be less than
1, as \code{1 - sum(alpha)} is the probability of no double reduction.}

\item{p}{The allele frequency of the major allele.}

\item{ploidy}{The ploidy of the species.}
}
\value{
A numeric vector of length \code{ploidy / 2 + 1}, where element
\code{i} is the probability that a gamete carries \code{i-1} copies of
the major allele.
}
\description{
Given the rate of double reduction and the major allele frequency, this
function will calculate the gametic frequencies.
}
\examples{
p_from_alpha(0.2, 0.5, 4)

}
\author{
David Gerard
}
