% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/River_Engineering.R
\name{shear_str}
\alias{shear_str}
\title{Shear stress, shear velocity, and dimensionless shear stress}
\usage{
shear_str(h0, J, dm = NULL, h = NULL, rho = 1000)
}
\arguments{
\item{h0}{Numeric. Total water depth [m].}

\item{J}{Numeric. Bottom slope [-].}

\item{dm}{Numeric or NULL. Median grain size (\code{d50}) of sediment [mm].}

\item{h}{Numeric or NULL. Local water depth at the point of interest [m].
If \code{NULL}, considered equal to \code{h0}.}

\item{rho}{Numeric. Density of water [kg/m3], default is 1000.}
}
\value{
A named list with components:
\item{tau}{Shear stress [N/m2].}
\item{U}{Shear velocity [m/s].}
\item{tau_st}{Dimensionless shear stress [-], if \code{dm} is provided,
otherwise \code{NA}.}
}
\description{
Calculates shear stress, shear velocity, and dimensionless shear stress
based on water depth, slope, and grain size.
}
\examples{
# Calculate shear stress at bank bottom
shear_str(h0 = 3.31, J = 0.0022)$tau

# Calculate shear stress at bank middle
shear_str(h0 = 3.31, J = 0.0022, h = 1.6)$tau

# Calculate dimensionless shear stress
shear_str(h0 = 3.31, J = 0.0022, dm = 100)$tau_st
}
\references{
Bezzola (2012). Flussbau, Vorlesungsmanuskript, ETH Zuerich
}
