\name{plot_out}

\alias{plot_out}

\title{
Plotting observed vs. simulated data and uncertainty bands
}

\description{
The function \code{plot_out} takes the optimization/calibration or verification 
results of a hydrological model and generates the following plots: \cr

\bold{(*)}: When \code{do.png == TRUE}, graphics are written to disk. \cr
\bold{(**)}: Multiple graphs are generated corresponding to the targets specified 
in the optimization process. \cr

\enumerate{
  \item \strong{ModelOut_BCS_from_Pareto_Optimal_Front_vs_Obs}: A graphical 
  comparison of time series for observed and simulated variables, using the 
  simulation of the best compromise solution. \cr
  
  \item \strong{ModelOut_from_Pareto_Optimal_Front}: An uncertainty band that 
  encompasses the simulations given by all the solutions on the Pareto Optimal Front, 
  displayed in a time series. The time series of the best compromise solution is 
  also distinguished. \cr
  
  \item \strong{ModelOut_from_Pareto_Optimal_Front_vs_Obs}: A graphical 
  comparison of time series for observed and simulated variables, using an 
  uncertainty band that encompasses the simulations given by all solutions on 
  the Pareto Optimal Front. \cr
}
}

\usage{
plot_out(Results,
         model.out = NULL,
         analysis.period = NULL, 
         model.out.bcs = NULL, 
         bcs = NULL, 
         obs.var = NULL,
         dimensions = NULL,
         obj.names = NULL,
         dates.cal = NULL, 
         dates.warmup = NULL, 
         var.names = NULL,
         var.units = NULL,
         xlim = NULL,
         ylim = NULL,
         digits = 4,
         col.band = "skyblue",
         col.bcs = "mediumblue",
         col.obs = "black",
         lwd = 0.75,
         pch.bcs = 15,
         pch.obs = 15,
         main = "study case #1",
         drty.out = "MOPSO.out",
         cex.pt = 0.25, 
         cex.main = 1,
         cex.lab = 1,
         cex.axis = 1,
         do.png = FALSE,
         legend.obs = "Observation",
         legend.bcs = "Best compromise solution",
         legend.band = "Pareto front bands")
}

\arguments{
  \item{Results}{(\code{list}) \cr
    Object containing preprocessed hydrological results.
  }
  \item{model.out}{(\code{list} or \code{NULL}) \cr
    Output from the hydrological model used for evaluation.
  }
  \item{analysis.period}{(\code{character} or \code{NULL}) \cr
    Time period for analysis (e.g., "calibration" or "verification").
  }
  \item{model.out.bcs}{(\code{list} or \code{NULL}) \cr
    Model output representing the "Best Compromise Solution" (BCS).
  }
  \item{bcs}{(\code{matrix} or \code{NULL}) \cr
    Parameters or results corresponding to the best compromise solution (BCS).
  }
  \item{obs.var}{(\code{list} or \code{NULL}) \cr
    Observed variables to be compared against the model outputs.
  }
  \item{dimensions}{(\code{matrix} or \code{NULL}) \cr
    Dimensions of the modeled problem, typically indicating the number of 
    objectives and variables.
  }
  \item{obj.names}{(\code{character} or \code{NULL}) \cr
    Names of the objectives.
  }
  \item{dates.cal}{(\code{Date} or \code{NULL}) \cr
    Dates of the calibration period.
  }
  \item{dates.warmup}{(\code{Date} or \code{NULL}) \cr
    Dates of the model's warm-up period.
  }
  \item{var.names}{(\code{character} or \code{NULL}) \cr
    Names of the modeled and observed variables.
  }
  \item{var.units}{(\code{character} or \code{NULL}) \cr
    Units of the modeled and observed variables.
  }
  \item{xlim}{(\code{numeric} or \code{NULL}) \cr
    Limits for the x-axis in the plots.
  }
  \item{ylim}{(\code{numeric} or \code{NULL}) \cr
    Limits for the y-axis in the plots.
  }
  \item{digits}{(\code{integer}) \cr
    Number of digits to use for rounding values in plots and legends.
  }
  \item{col.band}{(\code{character}) \cr
    Color used for the model uncertainty bands in the plots.
  }
  \item{col.bcs}{(\code{character}) \cr
    Color used for the line representing the best compromise solution (BCS).
  }
  \item{col.obs}{(\code{character}) \cr
    Color used for the observed variable lines in the plots.
  }
  \item{lwd}{(\code{numeric}) \cr
    Line width used in the plots for model and observation lines.
  }
  \item{pch.bcs}{(\code{integer}) \cr
    Symbol type for points in the plot representing the best compromise 
    solution (BCS).
  }
  \item{pch.obs}{(\code{integer}) \cr
    Symbol type for points in the plot representing the observations.
  }
  \item{main}{(\code{character}) \cr
    Main title for the plot.
  }
  \item{drty.out}{(\code{character}) \cr
    Output directory where plots will be saved if specified to save as PNG files.
  }
  \item{cex.pt}{(\code{numeric}) \cr
    Size of points in the plots.
  }
  \item{cex.main}{(\code{numeric}) \cr
    Size of the main title text in the plot.
  }
  \item{cex.lab}{(\code{numeric}) \cr
    Size of the axis label text in the plots.
  }
  \item{cex.axis}{(\code{numeric}) \cr
    Size of the axis values text in the plots.
  }
  \item{do.png}{(\code{logical}) \cr
    Boolean value indicating whether the plots should be saved as PNG files.
  }
  \item{legend.obs}{(\code{character}) \cr
    Legend text for observations.
  }
  \item{legend.bcs}{(\code{character}) \cr
    Legend text for the best compromise solution (BCS).
  }
  \item{legend.band}{(\code{character}) \cr
    Legend text for Pareto front bands.
  }
}

\value{
No return value; generates plots.
}

\author{
Rodrigo Marinao Rivas \email{ra.marinao.rivas@gmail.com},
Mauricio Zambrano-Bigiarini, \email{mzb.devel@gmail.com}
}

\seealso{
\code{\link{hydroMOPSO}}
}

\keyword{multi-objective optimisation}
\keyword{verification}
\keyword{hydrological model}
